/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.metrics;

import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.foundation.common.CommonThread;
import org.apache.servicecomb.foundation.metrics.MetricsConfig;
import org.apache.servicecomb.foundation.metrics.MetricsThread;
import org.apache.servicecomb.foundation.metrics.performance.PerfStat;
import org.apache.servicecomb.foundation.metrics.performance.PerfStatMonitorMgr;
import org.apache.servicecomb.foundation.metrics.performance.PerfStatSuccFail;

public class Metrics
extends CommonThread {
    protected static final ThreadLocal<Map<String, PerfStatSuccFail>> LOCAL_PERF_STAT_MAP = new ThreadLocal();
    private static PerfStatMonitorMgr perfMonitorMgr = new PerfStatMonitorMgr();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onCycle() throws Exception {
        long msNow = System.currentTimeMillis();
        PerfStatMonitorMgr perfStatMonitorMgr = perfMonitorMgr;
        synchronized (perfStatMonitorMgr) {
            perfMonitorMgr.onCycle(msNow, MetricsConfig.getMsCycle());
        }
    }

    public static long getMsTick() {
        return MetricsThread.getMsTick();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerPerfStat(PerfStat perfStat, int index) {
        PerfStatMonitorMgr perfStatMonitorMgr = perfMonitorMgr;
        synchronized (perfStatMonitorMgr) {
            perfMonitorMgr.registerPerfStat(perfStat, index);
        }
    }

    public static PerfStatSuccFail getOrCreateLocalPerfStat(String name, int index) {
        PerfStatSuccFail perfStat;
        Map<String, PerfStatSuccFail> map = LOCAL_PERF_STAT_MAP.get();
        if (map == null) {
            map = new HashMap<String, PerfStatSuccFail>();
            LOCAL_PERF_STAT_MAP.set(map);
        }
        if ((perfStat = map.get(name)) == null) {
            perfStat = new PerfStatSuccFail(name);
            map.put(name, perfStat);
            Metrics.registerPerfStat(perfStat, index);
        }
        return perfStat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, PerfStat> getMonitorPerfStat() {
        PerfStatMonitorMgr perfStatMonitorMgr = perfMonitorMgr;
        synchronized (perfStatMonitorMgr) {
            return perfMonitorMgr.getMonitorPerfStat();
        }
    }
}

