/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.metrics.performance;

import java.util.Arrays;
import org.apache.servicecomb.foundation.metrics.performance.PerfResult;
import org.apache.servicecomb.foundation.metrics.performance.PerfStatContext;

public class PerfStatData {
    private static long processBegin = System.currentTimeMillis();
    private static long[] segmentDef;
    private static final long[] SEGMENT_BOUNDRYS;
    private static String strSegmentDef;
    private String name;
    private long callCount;
    private long msgCount;
    private long msLatency;
    private long[] msLatencySegments = new long[segmentDef.length + 1];
    private static final int MILLI_COUNT_IN_SECOND = 1000;

    public PerfStatData(String name) {
        this.name = name;
    }

    public static void setSegmentDef(long[] segmentDef) {
        PerfStatData.segmentDef = segmentDef;
        StringBuilder sb = new StringBuilder();
        long last = 0L;
        for (long def : segmentDef) {
            sb.append(String.format("%-10s", String.format("[%d,%d)", last, def)));
            last = def;
        }
        sb.append(String.format("%-10s", String.format("[%d,...)", last)));
        strSegmentDef = sb.toString();
    }

    public static String getStrSegmentDef() {
        return strSegmentDef;
    }

    public String getName() {
        return this.name;
    }

    public long getCallCount() {
        return this.callCount;
    }

    public long getMsgCount() {
        return this.msgCount;
    }

    public long getMsLatency() {
        return this.msLatency;
    }

    public long[] getMsLatencySegments() {
        return this.msLatencySegments;
    }

    protected int findSegmentIdx(long latency) {
        long lastDef = 0L;
        for (int idx = 0; idx < segmentDef.length; ++idx) {
            long def = segmentDef[idx];
            if (latency >= lastDef && latency < def) {
                return idx;
            }
            lastDef = def;
        }
        return segmentDef.length;
    }

    public void add(int count, long latency) {
        int segmentIdx;
        ++this.callCount;
        this.msgCount += (long)count;
        this.msLatency += latency;
        int n = segmentIdx = this.findSegmentIdx(latency);
        this.msLatencySegments[n] = this.msLatencySegments[n] + 1L;
    }

    public void add(PerfStatContext context) {
        this.add(context.getMsgCount(), context.getLatency());
    }

    public void mergeFrom(PerfStatData other) {
        this.callCount += other.callCount;
        this.msgCount += other.msgCount;
        this.msLatency += other.msLatency;
        for (int idx = 0; idx < this.msLatencySegments.length; ++idx) {
            int n = idx;
            this.msLatencySegments[n] = this.msLatencySegments[n] + other.msLatencySegments[idx];
        }
    }

    public PerfResult calc(long msNow) {
        PerfResult perf = new PerfResult();
        perf.setName("  all " + this.name + "  :");
        perf.setCallCount(this.callCount);
        perf.setMsgCount(this.msgCount);
        perf.setAvgCallCount(this.callCount * 1000L / (msNow - processBegin > 0L ? msNow - processBegin : 1L));
        perf.setMsAvgLatency(this.callCount != 0L ? (double)this.msLatency / (double)this.callCount : 0.0);
        perf.setMsLatencySegments(this.msLatencySegments);
        return perf;
    }

    public PerfResult calc(PerfStatData lastCycle, long msCycle) {
        PerfResult perf = new PerfResult();
        long diffCount = this.callCount - lastCycle.callCount;
        perf.setName("  cycle " + this.name + ":");
        perf.setCallCount(diffCount);
        perf.setMsgCount(this.msgCount - lastCycle.msgCount);
        perf.setAvgCallCount(diffCount * 1000L / msCycle);
        perf.setMsAvgLatency(diffCount != 0L ? (double)(this.msLatency - lastCycle.msLatency) / (double)diffCount : 0.0);
        long[] clone = Arrays.copyOf(this.msLatencySegments, this.msLatencySegments.length);
        long[] lastCycleSegments = lastCycle.getMsLatencySegments();
        for (int idx = 0; idx < clone.length; ++idx) {
            int n = idx;
            clone[n] = clone[n] - lastCycleSegments[idx];
        }
        perf.setMsLatencySegments(clone);
        return perf;
    }

    static {
        SEGMENT_BOUNDRYS = new long[]{20L, 100L, 300L, 500L};
        PerfStatData.setSegmentDef(SEGMENT_BOUNDRYS);
    }
}

