/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.metrics.performance;

import java.util.ArrayList;
import java.util.List;
import org.apache.servicecomb.foundation.metrics.performance.PerfResult;
import org.apache.servicecomb.foundation.metrics.performance.PerfStat;
import org.apache.servicecomb.foundation.metrics.performance.PerfStatImpl;

public class PerfStatMonitor {
    private List<PerfStat> threadStats = new ArrayList<PerfStat>();
    private String name;
    private int index;
    private PerfStat sumStat;
    private List<PerfResult> perfResultList;

    public PerfStatMonitor(String name, int index) {
        this.name = name;
        this.index = index;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public void addThreadStat(PerfStat threadStat) {
        this.threadStats.add(threadStat);
    }

    public void calcCycle(long msNow, long msCycle) {
        PerfStatImpl newSumStat = new PerfStatImpl(null);
        for (PerfStat threadStat : this.threadStats) {
            newSumStat.mergeFrom(threadStat);
        }
        this.perfResultList = new ArrayList<PerfResult>();
        newSumStat.calc(msNow, this.perfResultList);
        newSumStat.calc(this.sumStat, msCycle, this.perfResultList);
        this.sumStat = newSumStat;
    }

    public void format(StringBuilder sb, String fmt) {
        for (PerfResult result : this.perfResultList) {
            String msg = String.format(result.getName() + fmt, result.getCallCount(), result.getMsgCount(), result.getAvgCallCount(), result.getMsAvgLatency(), result.segmentsToString("%-10d"));
            sb.append(msg);
        }
    }

    public PerfStat getPerfStat() {
        return this.sumStat;
    }

    public List<PerfResult> getPerfResultList() {
        return this.perfResultList;
    }
}

