/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.metrics.publish;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.servicecomb.foundation.common.exceptions.ServiceCombException;

public class Metric {
    private String name;
    private Map<String, String> tags;
    private double value;

    public String getName() {
        return this.name;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Metric(String id, double value) {
        if (!this.validateMetricId(id)) throw new ServiceCombException("bad format id " + id);
        this.tags = new HashMap<String, String>();
        this.value = value;
        String[] nameAndTag = id.split("[()]");
        if (nameAndTag.length == 1) {
            this.processIdWithoutTags(id, nameAndTag[0]);
            return;
        } else {
            if (nameAndTag.length != 2) throw new ServiceCombException("bad format id " + id);
            this.processIdHadTags(id, nameAndTag);
        }
    }

    private void processIdWithoutTags(String id, String name) {
        if (id.endsWith(")")) {
            throw new ServiceCombException("bad format id " + id);
        }
        this.name = name;
    }

    private void processIdHadTags(String id, String[] nameAndTag) {
        String[] tagAnValues;
        this.name = nameAndTag[0];
        for (String tagAnValue : tagAnValues = nameAndTag[1].split(",")) {
            String[] kv = tagAnValue.split("=");
            if (kv.length != 2) {
                throw new ServiceCombException("bad format tag " + id);
            }
            this.tags.put(kv[0], kv[1]);
        }
    }

    public double getValue() {
        return this.value;
    }

    public double getValue(TimeUnit unit) {
        if (this.tags.containsKey("unit") && !this.tags.get("unit").equals(String.valueOf((Object)unit))) {
            return unit.convert((long)this.value, TimeUnit.valueOf(this.tags.get("unit")));
        }
        return this.value;
    }

    public int getTagsCount() {
        return this.tags.size();
    }

    public boolean containsTagKey(String tagKey) {
        return this.tags.containsKey(tagKey);
    }

    public String getTagValue(String tagKey) {
        return this.tags.get(tagKey);
    }

    public boolean containsTag(String tagKey, String tagValue) {
        return this.tags.containsKey(tagKey) && tagValue.equals(this.tags.get(tagKey));
    }

    public boolean containsTag(String ... tags) {
        if (tags.length >= 2 && tags.length % 2 == 0) {
            for (int i = 0; i < tags.length; i += 2) {
                if (this.containsTag(tags[i], tags[i + 1])) continue;
                return false;
            }
            return true;
        }
        throw new ServiceCombException("bad tags count : " + String.join((CharSequence)",", tags));
    }

    private int getCharCount(String id, char c) {
        int count = 0;
        for (char cr : id.toCharArray()) {
            if (cr != c) continue;
            ++count;
        }
        return count;
    }

    private boolean validateMetricId(String id) {
        return id != null && !"".equals(id) && !id.endsWith("(") && this.getCharCount(id, '(') <= 1 && this.getCharCount(id, ')') <= 1;
    }
}

