/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.metrics.publish;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.servicecomb.foundation.metrics.publish.Metric;

public class MetricNode {
    private final String tagKey;
    private final List<Metric> metrics;
    private final Map<String, MetricNode> children;

    public MetricNode(Iterable<Metric> metrics, String ... groupTagKeys) {
        if (groupTagKeys == null || groupTagKeys.length == 0) {
            this.tagKey = null;
            this.metrics = Lists.newArrayList(metrics);
            this.children = null;
        } else {
            this.tagKey = groupTagKeys[0];
            this.metrics = null;
            this.children = new HashMap<String, MetricNode>();
            Map<String, List<Metric>> groups = this.groupByTag(metrics, this.tagKey);
            if (groupTagKeys.length == 1) {
                for (Map.Entry<String, List<Metric>> group : groups.entrySet()) {
                    this.children.put(group.getKey(), new MetricNode(null, group.getValue(), null));
                }
            } else {
                for (Map.Entry<String, List<Metric>> group : groups.entrySet()) {
                    this.children.put(group.getKey(), new MetricNode((Iterable<Metric>)group.getValue(), Arrays.copyOfRange(groupTagKeys, 1, groupTagKeys.length)));
                }
            }
        }
    }

    private MetricNode(String tagKey, List<Metric> metrics, Map<String, MetricNode> children) {
        this.tagKey = tagKey;
        this.metrics = metrics;
        this.children = children;
    }

    public Iterable<Metric> getMetrics() {
        return this.metrics;
    }

    public int getMetricCount() {
        return this.metrics.size();
    }

    public Iterable<Map.Entry<String, MetricNode>> getChildren() {
        return this.children.entrySet();
    }

    public MetricNode getChildren(String tagValue) {
        return this.children.get(tagValue);
    }

    public int getChildrenCount() {
        return this.children.size();
    }

    public MetricNode getChildrenNode(String tagValue) {
        return this.children.get(tagValue);
    }

    public Double getFirstMatchMetricValue(String tagKey, String tagValue) {
        for (Metric metric : this.metrics) {
            if (!metric.containsTag(tagKey, tagValue)) continue;
            return metric.getValue();
        }
        return Double.NaN;
    }

    public Double getFirstMatchMetricValue(TimeUnit unit, String tagKey, String tagValue) {
        for (Metric metric : this.metrics) {
            if (!metric.containsTag(tagKey, tagValue)) continue;
            return metric.getValue(unit);
        }
        return Double.NaN;
    }

    public Double getFirstMatchMetricValue(String ... tags) {
        for (Metric metric : this.metrics) {
            if (!metric.containsTag(tags)) continue;
            return metric.getValue();
        }
        return Double.NaN;
    }

    public Double getFirstMatchMetricValue(TimeUnit unit, String ... tags) {
        for (Metric metric : this.metrics) {
            if (!metric.containsTag(tags)) continue;
            return metric.getValue(unit);
        }
        return Double.NaN;
    }

    public double getMatchStatisticMetricValue(String statisticValue) {
        return this.getFirstMatchMetricValue("statistic", statisticValue);
    }

    public double getMatchStatisticMetricValue(TimeUnit unit, String statisticValue) {
        return this.getFirstMatchMetricValue(unit, "statistic", statisticValue);
    }

    private Map<String, List<Metric>> groupByTag(Iterable<Metric> metrics, String tagKey) {
        HashMap<String, List<Metric>> groups = new HashMap<String, List<Metric>>();
        for (Metric metric : metrics) {
            if (!metric.containsTagKey(tagKey)) continue;
            groups.computeIfAbsent(metric.getTagValue(tagKey), g -> new ArrayList()).add(metric);
        }
        return groups;
    }
}

