/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.metrics.publish;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.foundation.common.exceptions.ServiceCombException;
import org.apache.servicecomb.foundation.metrics.publish.Metric;
import org.apache.servicecomb.foundation.metrics.publish.MetricNode;

public class MetricsLoader {
    private final Map<String, List<Metric>> metrics = new HashMap<String, List<Metric>>();

    public MetricsLoader(Map<String, Double> metrics) {
        for (Map.Entry<String, Double> entry : metrics.entrySet()) {
            Metric metric = new Metric(entry.getKey(), entry.getValue());
            this.metrics.computeIfAbsent(metric.getName(), m -> new ArrayList()).add(metric);
        }
    }

    public MetricNode getMetricTree(String id, String ... groupTagKeys) {
        if (this.containsId(id)) {
            return new MetricNode((Iterable<Metric>)this.metrics.get(id), groupTagKeys);
        }
        throw new ServiceCombException("no such id : " + id);
    }

    public boolean containsId(String id) {
        return this.metrics.containsKey(id);
    }

    public double getFirstMatchMetricValue(String name, String tagKey, String tagValue) {
        if (this.metrics.containsKey(name)) {
            for (Metric metric : this.metrics.get(name)) {
                if (!metric.containsTag(tagKey, tagValue)) continue;
                return metric.getValue();
            }
        }
        return Double.NaN;
    }
}

