/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.definition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.servicecomb.core.definition.CommonService;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.definition.SchemaMeta;
import org.apache.servicecomb.foundation.common.RegisterManager;
import org.apache.servicecomb.serviceregistry.RegistryUtils;

public class MicroserviceMeta
extends CommonService<OperationMeta> {
    private String appId;
    private String shortName;
    private ClassLoader classLoader;
    private RegisterManager<String, SchemaMeta> idSchemaMetaMgr;
    private Map<Class<?>, List<SchemaMeta>> intfSchemaMetaMgr = new ConcurrentHashMap();
    private final Object intfSchemaLock = new Object();
    private Map<String, Object> extData = new ConcurrentHashMap<String, Object>();

    public MicroserviceMeta(String microserviceName) {
        this.classLoader = Thread.currentThread().getContextClassLoader();
        this.parseMicroserviceName(microserviceName);
        this.createOperationMgr("Operation meta mgr for microservice " + microserviceName);
        this.idSchemaMetaMgr = new RegisterManager("Schema meta id mgr for microservice " + microserviceName);
    }

    public void regSchemaMeta(SchemaMeta schemaMeta) {
        this.idSchemaMetaMgr.register((Object)schemaMeta.getSchemaId(), (Object)schemaMeta);
        this.regSchemaAndInterface(schemaMeta);
        for (OperationMeta operationMeta : schemaMeta.getOperations()) {
            this.regOperation(operationMeta.getSchemaQualifiedName(), operationMeta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void regSchemaAndInterface(SchemaMeta schemaMeta) {
        Class<?> intf = schemaMeta.getSwaggerIntf();
        Object object = this.intfSchemaLock;
        synchronized (object) {
            List schemaList = this.intfSchemaMetaMgr.computeIfAbsent(intf, k -> new ArrayList());
            schemaList.add(schemaMeta);
        }
    }

    public SchemaMeta ensureFindSchemaMeta(String schemaId) {
        return (SchemaMeta)this.idSchemaMetaMgr.ensureFindValue((Object)schemaId);
    }

    public SchemaMeta findSchemaMeta(String schemaId) {
        return (SchemaMeta)this.idSchemaMetaMgr.findValue((Object)schemaId);
    }

    public SchemaMeta ensureFindSchemaMeta(Class<?> schemaIntf) {
        SchemaMeta schemaMeta = this.findSchemaMeta(schemaIntf);
        if (schemaMeta == null) {
            String msg = String.format("No schema interface is %s.", schemaIntf.getName());
            throw new Error(msg);
        }
        return schemaMeta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaMeta findSchemaMeta(Class<?> schemaIntf) {
        List<SchemaMeta> schemaList = this.intfSchemaMetaMgr.get(schemaIntf);
        if (schemaList == null) {
            return null;
        }
        if (schemaList.size() > 1) {
            String msg = String.format("More than one schema interface is %s, please use schemaId to choose a schema.", schemaIntf.getName());
            throw new Error(msg);
        }
        Object object = this.intfSchemaLock;
        synchronized (object) {
            return schemaList.get(0);
        }
    }

    public Collection<SchemaMeta> getSchemaMetas() {
        return this.idSchemaMetaMgr.values();
    }

    public void putExtData(String key, Object data) {
        this.extData.put(key, data);
    }

    public <T> T getExtData(String key) {
        return (T)this.extData.get(key);
    }

    public String getAppId() {
        return this.appId;
    }

    public String getShortName() {
        return this.shortName;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected void parseMicroserviceName(String microserviceName) {
        int idxAt = microserviceName.indexOf(":");
        if (idxAt == -1) {
            this.appId = RegistryUtils.getAppId();
            this.shortName = this.name = microserviceName;
            return;
        }
        this.appId = microserviceName.substring(0, idxAt);
        this.name = microserviceName;
        this.shortName = microserviceName.substring(idxAt + 1);
    }
}

