/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.definition;

import io.swagger.models.HttpMethod;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.core.Handler;
import org.apache.servicecomb.core.definition.CommonService;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.definition.SchemaUtils;
import org.apache.servicecomb.core.exception.ExceptionUtils;
import org.apache.servicecomb.foundation.common.utils.ReflectUtils;
import org.apache.servicecomb.swagger.generator.core.utils.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaMeta
extends CommonService<OperationMeta> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaMeta.class);
    private String packageName;
    private Swagger swagger;
    private MicroserviceMeta microserviceMeta;
    private String microserviceQualifiedName;
    private Class<?> swaggerIntf;
    private List<Handler> consumerHandlerChain;
    private List<Handler> providerHandlerChain;

    public SchemaMeta(Swagger swagger, MicroserviceMeta microserviceMeta, String schemaId) {
        this.packageName = SchemaUtils.generatePackageName(microserviceMeta, schemaId);
        this.swagger = swagger;
        this.name = schemaId;
        this.microserviceMeta = microserviceMeta;
        this.microserviceQualifiedName = microserviceMeta.getName() + "." + schemaId;
        this.swaggerIntf = ClassUtils.getOrCreateInterface((Swagger)swagger, (ClassLoader)microserviceMeta.getClassLoader(), (String)this.packageName);
        this.createOperationMgr("schemaMeta " + schemaId + " operation mgr");
        this.operationMgr.setRegisterErrorFmt("Operation name repeat, schema=%s, operation=%s");
        this.initOperations();
    }

    public String getPackageName() {
        return this.packageName;
    }

    private void initOperations() {
        for (Map.Entry entry : this.swagger.getPaths().entrySet()) {
            String strPath = (String)entry.getKey();
            Path path = (Path)entry.getValue();
            for (Map.Entry operationEntry : path.getOperationMap().entrySet()) {
                Operation operation = (Operation)operationEntry.getValue();
                if (operation.getOperationId() == null) {
                    throw ExceptionUtils.operationIdInvalid(this.getSchemaId(), strPath);
                }
                Method method = ReflectUtils.findMethod(this.swaggerIntf, (String)operation.getOperationId());
                if (method == null) {
                    LOGGER.warn("method {} not found in swagger interface {}, schemaId={}", new Object[]{operation.getOperationId(), this.swaggerIntf.getName(), this.getSchemaId()});
                    continue;
                }
                String httpMethod = ((HttpMethod)operationEntry.getKey()).name();
                OperationMeta operationMeta = new OperationMeta();
                operationMeta.init(this, method, strPath, httpMethod, operation);
                this.operationMgr.register((Object)method.getName(), (Object)operationMeta);
            }
        }
    }

    public Swagger getSwagger() {
        return this.swagger;
    }

    public String getSchemaId() {
        return this.name;
    }

    public String getMicroserviceQualifiedName() {
        return this.microserviceQualifiedName;
    }

    public String getMicroserviceName() {
        return this.microserviceMeta.getName();
    }

    public MicroserviceMeta getMicroserviceMeta() {
        return this.microserviceMeta;
    }

    public Class<?> getSwaggerIntf() {
        return this.swaggerIntf;
    }

    public List<Handler> getConsumerHandlerChain() {
        return this.consumerHandlerChain;
    }

    public void setConsumerHandlerChain(List<Handler> consumerHandlerChain) {
        this.consumerHandlerChain = consumerHandlerChain;
    }

    public List<Handler> getProviderHandlerChain() {
        return this.providerHandlerChain;
    }

    public void setProviderHandlerChain(List<Handler> providerHandlerChain) {
        this.providerHandlerChain = providerHandlerChain;
    }
}

