/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.definition.classloader;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicroserviceClassLoader
extends ClassLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicroserviceClassLoader.class);
    private final String appId;
    private final String microserviceName;
    private final String version;

    public MicroserviceClassLoader(String appId, String microserviceName, String version) {
        super(Thread.currentThread().getContextClassLoader());
        this.appId = appId;
        this.microserviceName = microserviceName;
        this.version = version;
        LOGGER.info("create classloader for microservice {}:{}:{}.", new Object[]{appId, microserviceName, version});
    }

    public String getAppId() {
        return this.appId;
    }

    public String getMicroserviceName() {
        return this.microserviceName;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return String.format("MicroserviceClassLoader %s:%s:%s", this.appId, this.microserviceName, this.version);
    }

    protected void finalize() throws Throwable {
        LOGGER.info("gc: classloader of microservice {}:{}.", (Object)this.microserviceName, (Object)this.version);
        super.finalize();
    }
}

