/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.definition.loader;

import io.swagger.models.Swagger;
import java.net.URL;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.MicroserviceMetaManager;
import org.apache.servicecomb.core.definition.SchemaMeta;
import org.apache.servicecomb.core.definition.SchemaUtils;
import org.apache.servicecomb.core.handler.ConsumerHandlerManager;
import org.apache.servicecomb.core.handler.ProducerHandlerManager;
import org.apache.servicecomb.serviceregistry.RegistryUtils;
import org.apache.servicecomb.serviceregistry.api.registry.BasePath;
import org.apache.servicecomb.serviceregistry.api.registry.Microservice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class SchemaLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaLoader.class);
    @Inject
    protected MicroserviceMetaManager microserviceMetaManager;

    public void setMicroserviceMetaManager(MicroserviceMetaManager microserviceMetaManager) {
        this.microserviceMetaManager = microserviceMetaManager;
    }

    public SchemaMeta registerSchema(String microserviceName, Resource resource) {
        try {
            String schemaId = FilenameUtils.getBaseName((String)resource.getFilename());
            String swaggerContent = IOUtils.toString((URL)resource.getURL());
            SchemaMeta schemaMeta = this.registerSchema(microserviceName, schemaId, swaggerContent);
            return schemaMeta;
        }
        catch (Throwable e) {
            throw new Error(e);
        }
    }

    public SchemaMeta registerSchema(String microserviceName, String schemaId, String swaggerContent) {
        Swagger swagger = SchemaUtils.parseSwagger(swaggerContent);
        if (swagger == null) {
            throw new Error(String.format("Parse the swagger for %s:%s failed", microserviceName, schemaId));
        }
        return this.registerSchema(microserviceName, schemaId, swagger);
    }

    public SchemaMeta registerSchema(String microserviceName, String schemaId, Swagger swagger) {
        MicroserviceMeta microserviceMeta = this.microserviceMetaManager.getOrCreateMicroserviceMeta(microserviceName);
        return this.registerSchema(microserviceMeta, schemaId, swagger);
    }

    public SchemaMeta registerSchema(MicroserviceMeta microserviceMeta, String schemaId, Swagger swagger) {
        String microserviceName = microserviceMeta.getName();
        LOGGER.info("register schema {}/{}/{}", new Object[]{microserviceMeta.getAppId(), microserviceName, schemaId});
        SchemaMeta schemaMeta = new SchemaMeta(swagger, microserviceMeta, schemaId);
        List producerHandlerChain = (List)ProducerHandlerManager.INSTANCE.getOrCreate(microserviceName);
        schemaMeta.setProviderHandlerChain(producerHandlerChain);
        List consumerHandlerChain = (List)ConsumerHandlerManager.INSTANCE.getOrCreate(microserviceName);
        schemaMeta.setConsumerHandlerChain(consumerHandlerChain);
        microserviceMeta.regSchemaMeta(schemaMeta);
        this.putSelfBasePathIfAbsent(microserviceName, swagger.getBasePath());
        return schemaMeta;
    }

    public void putSelfBasePathIfAbsent(String microserviceName, String basePath) {
        if (basePath == null || basePath.length() == 0) {
            return;
        }
        Microservice microservice = RegistryUtils.getMicroservice();
        if (!microservice.getServiceName().equals(microserviceName)) {
            return;
        }
        String urlPrefix = System.getProperty("urlPrefix");
        if (!StringUtils.isEmpty((Object)urlPrefix) && !basePath.startsWith(urlPrefix)) {
            basePath = urlPrefix + basePath;
        }
        List paths = microservice.getPaths();
        for (BasePath path : paths) {
            if (!path.getPath().equals(basePath)) continue;
            return;
        }
        BasePath basePathObj = new BasePath();
        basePathObj.setPath(basePath);
        paths.add(basePathObj);
    }
}

