/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.definition.schema;

import io.swagger.models.Swagger;
import javax.inject.Inject;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.MicroserviceVersionMeta;
import org.apache.servicecomb.core.definition.SchemaMeta;
import org.apache.servicecomb.core.definition.SchemaUtils;
import org.apache.servicecomb.core.definition.loader.SchemaListenerManager;
import org.apache.servicecomb.core.definition.schema.AbstractSchemaFactory;
import org.apache.servicecomb.core.definition.schema.ConsumerSchemaContext;
import org.apache.servicecomb.serviceregistry.RegistryUtils;
import org.apache.servicecomb.serviceregistry.api.registry.Microservice;
import org.apache.servicecomb.serviceregistry.client.ServiceRegistryClient;
import org.apache.servicecomb.serviceregistry.consumer.AppManager;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceVersion;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceVersionRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class ConsumerSchemaFactory
extends AbstractSchemaFactory<ConsumerSchemaContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerSchemaFactory.class);
    @Inject
    protected SchemaListenerManager schemaListenerManager;
    AppManager appManager;
    private final Object lock = new Object();

    public void setSchemaListenerManager(SchemaListenerManager schemaListenerManager) {
        this.schemaListenerManager = schemaListenerManager;
    }

    public void setAppManager(AppManager appManager) {
        this.appManager = appManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MicroserviceMeta getOrCreateMicroserviceMeta(String microserviceName, String versionRule) {
        MicroserviceMeta microserviceMeta = (MicroserviceMeta)this.microserviceMetaManager.findValue(microserviceName);
        if (microserviceMeta != null) {
            return microserviceMeta;
        }
        Object object = this.lock;
        synchronized (object) {
            MicroserviceVersionRule microserviceVersionRule;
            MicroserviceVersion microserviceVersion;
            microserviceMeta = (MicroserviceMeta)this.microserviceMetaManager.findValue(microserviceName);
            if (microserviceMeta != null) {
                return microserviceMeta;
            }
            microserviceMeta = new MicroserviceMeta(microserviceName);
            if (this.appManager == null) {
                this.appManager = RegistryUtils.getServiceRegistry().getAppManager();
            }
            if ((microserviceVersion = (microserviceVersionRule = this.appManager.getOrCreateMicroserviceVersionRule(microserviceMeta.getAppId(), microserviceName, versionRule)).getLatestMicroserviceVersion()) == null) {
                throw new IllegalStateException(String.format("Probably invoke a service before it is registered, appId=%s, name=%s", microserviceMeta.getAppId(), microserviceName));
            }
            if (MicroserviceVersionMeta.class.isInstance(microserviceVersion)) {
                microserviceMeta = ((MicroserviceVersionMeta)microserviceVersion).getMicroserviceMeta();
            } else {
                this.getOrCreateConsumerSchema(microserviceMeta, microserviceVersion.getMicroservice());
                this.schemaListenerManager.notifySchemaListener(microserviceMeta);
            }
            LOGGER.info("Found schema ids from service center, {}:{}:{}:{}", new Object[]{microserviceMeta.getAppId(), microserviceName, versionRule, microserviceVersion.getMicroservice().getSchemas()});
            this.microserviceMetaManager.register(microserviceName, microserviceMeta);
            return microserviceMeta;
        }
    }

    public void getOrCreateConsumerSchema(MicroserviceMeta microserviceMeta, Microservice microservice) {
        for (String schemaId : microservice.getSchemas()) {
            ConsumerSchemaContext context = new ConsumerSchemaContext();
            context.setMicroserviceMeta(microserviceMeta);
            context.setMicroservice(microservice);
            context.setSchemaId(schemaId);
            context.setProviderClass(null);
            this.getOrCreateSchema(context);
        }
    }

    @Override
    protected SchemaMeta createSchema(ConsumerSchemaContext context) {
        Swagger swagger = this.loadSwagger(context);
        return this.schemaLoader.registerSchema(context.getMicroserviceMeta(), context.getSchemaId(), swagger);
    }

    @Override
    protected Swagger loadSwagger(ConsumerSchemaContext context) {
        Swagger swagger = super.loadSwagger(context);
        if (swagger != null) {
            return swagger;
        }
        ServiceRegistryClient client = RegistryUtils.getServiceRegistryClient();
        String schemaContent = client.getSchema(context.getMicroservice().getServiceId(), context.getSchemaId());
        LOGGER.info("load schema from service center, microservice={}:{}:{}, schemaId={}, result={}", new Object[]{context.getMicroservice().getAppId(), context.getMicroservice().getServiceName(), context.getMicroservice().getVersion(), context.getSchemaId(), !StringUtils.isEmpty((Object)schemaContent)});
        if (schemaContent != null) {
            return SchemaUtils.parseSwagger(schemaContent);
        }
        throw new Error(String.format("no schema in local, and can not get schema from service center, %s:%s", context.getMicroserviceName(), context.getSchemaId()));
    }
}

