/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.executor;

import com.netflix.config.DynamicPropertyFactory;
import java.util.concurrent.Executor;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.foundation.common.utils.BeanUtils;

public final class ExecutorManager {
    public static final String KEY_EXECUTORS_PREFIX = "cse.executors.Provider.";
    public static final String KEY_EXECUTORS_DEFAULT = "cse.executors.default";
    public static final String EXECUTOR_GROUP_THREADPOOL = "cse.executor.groupThreadPool";
    public static final String EXECUTOR_REACTIVE = "cse.executor.reactive";
    public static final String EXECUTOR_DEFAULT = "cse.executor.groupThreadPool";

    private ExecutorManager() {
    }

    public static Executor findExecutor(OperationMeta operationMeta) {
        return ExecutorManager.findExecutor(operationMeta, null);
    }

    public static Executor findExecutor(OperationMeta operationMeta, Executor defaultOperationExecutor) {
        Executor executor = ExecutorManager.findByKey(KEY_EXECUTORS_PREFIX + operationMeta.getSchemaQualifiedName());
        if (executor != null) {
            return executor;
        }
        if (defaultOperationExecutor != null) {
            return defaultOperationExecutor;
        }
        executor = ExecutorManager.findByKey(KEY_EXECUTORS_PREFIX + operationMeta.getSchemaMeta().getName());
        if (executor != null) {
            return executor;
        }
        executor = ExecutorManager.findByKey(KEY_EXECUTORS_DEFAULT);
        if (executor != null) {
            return executor;
        }
        return (Executor)BeanUtils.getBean((String)"cse.executor.groupThreadPool");
    }

    protected static Executor findByKey(String beanIdKey) {
        String beanId = DynamicPropertyFactory.getInstance().getStringProperty(beanIdKey, null).get();
        if (beanId != null) {
            return (Executor)BeanUtils.getBean((String)beanId);
        }
        return null;
    }
}

