/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.handler;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.servicecomb.core.Handler;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.apache.servicecomb.swagger.invocation.InvocationType;
import org.apache.servicecomb.swagger.invocation.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShutdownHookHandler
implements Handler,
Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ShutdownHookHandler.class);
    public static final ShutdownHookHandler INSTANCE = new ShutdownHookHandler();
    private final AtomicLong requestCounter = new AtomicLong(0L);
    private final AtomicLong responseCounter = new AtomicLong(0L);
    private final int timeout = 600;
    private final int period = 10;
    private volatile boolean shuttingDown = false;

    private ShutdownHookHandler() {
        Runtime.getRuntime().addShutdownHook(new Thread(this));
    }

    public long getActiveCount() {
        return this.requestCounter.get() - this.responseCounter.get();
    }

    @Override
    public void handle(Invocation invocation, AsyncResponse asyncResp) throws Exception {
        if (this.shuttingDown) {
            asyncResp.handle(Response.createFail((InvocationType)invocation.getInvocationType(), (String)"shutting down in progress"));
            return;
        }
        this.requestCounter.incrementAndGet();
        try {
            invocation.next(resp -> {
                try {
                    asyncResp.handle(resp);
                }
                finally {
                    this.responseCounter.incrementAndGet();
                }
            });
        }
        catch (Throwable e) {
            this.responseCounter.incrementAndGet();
            throw e;
        }
    }

    @Override
    public void run() {
        this.shuttingDown = true;
        LOG.warn("handler chain is shutting down");
        int time = 0;
        while (this.getActiveCount() != 0L && time <= 600) {
            try {
                TimeUnit.SECONDS.sleep(10L);
            }
            catch (InterruptedException e) {
                LOG.warn(e.getMessage());
            }
            LOG.warn("waiting invocation to finish in seconds " + (time += 10));
        }
        LOG.warn("handler chain is shut down");
    }
}

