/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.provider.producer;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.apache.servicecomb.core.ProducerProvider;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.MicroserviceMetaManager;
import org.apache.servicecomb.core.definition.SchemaMeta;
import org.apache.servicecomb.core.definition.SchemaUtils;
import org.apache.servicecomb.serviceregistry.RegistryUtils;
import org.apache.servicecomb.serviceregistry.api.registry.Microservice;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProducerProviderManager {
    @Autowired(required=false)
    private List<ProducerProvider> producerProviderList = Collections.emptyList();
    @Inject
    private MicroserviceMetaManager microserviceMetaManager;

    public void init() throws Exception {
        for (ProducerProvider provider : this.producerProviderList) {
            provider.init();
        }
        Microservice microservice = RegistryUtils.getMicroservice();
        MicroserviceMeta microserviceMeta = this.microserviceMetaManager.getOrCreateMicroserviceMeta(microservice);
        for (SchemaMeta schemaMeta : microserviceMeta.getSchemaMetas()) {
            String content = SchemaUtils.swaggerToString(schemaMeta.getSwagger());
            microservice.addSchema(schemaMeta.getSchemaId(), content);
        }
    }
}

