/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.unittest;

import io.swagger.models.Swagger;
import java.util.Collections;
import java.util.List;
import mockit.Mock;
import mockit.MockUp;
import org.apache.servicecomb.core.CseContext;
import org.apache.servicecomb.core.Handler;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.MicroserviceMetaManager;
import org.apache.servicecomb.core.definition.SchemaMeta;
import org.apache.servicecomb.core.definition.loader.SchemaListenerManager;
import org.apache.servicecomb.core.definition.loader.SchemaLoader;
import org.apache.servicecomb.core.definition.schema.ConsumerSchemaFactory;
import org.apache.servicecomb.core.handler.ConsumerHandlerManager;
import org.apache.servicecomb.core.handler.ProducerHandlerManager;
import org.apache.servicecomb.core.handler.config.Config;
import org.apache.servicecomb.core.handler.impl.SimpleLoadBalanceHandler;
import org.apache.servicecomb.core.provider.consumer.ConsumerProviderManager;
import org.apache.servicecomb.foundation.common.utils.BeanUtils;
import org.apache.servicecomb.swagger.generator.core.unittest.UnitTestSwaggerUtils;
import org.mockito.Mockito;
import org.springframework.context.ApplicationContext;

public class UnitTestMeta {
    private static boolean inited = false;
    private static MicroserviceMetaManager microserviceMetaManager = new MicroserviceMetaManager();
    private static SchemaListenerManager schemaListenerManager = new SchemaListenerManager();
    private SchemaLoader schemaLoader = new SchemaLoader(){

        @Override
        public void putSelfBasePathIfAbsent(String microserviceName, String basePath) {
        }
    };

    public static synchronized void init() {
        if (inited) {
            return;
        }
        ConsumerProviderManager consumerProviderManager = new ConsumerProviderManager();
        ConsumerSchemaFactory consumerSchemaFactory = new ConsumerSchemaFactory();
        consumerSchemaFactory.setMicroserviceMetaManager(microserviceMetaManager);
        consumerSchemaFactory.setSchemaListenerManager(schemaListenerManager);
        consumerProviderManager.setConsumerSchemaFactory(consumerSchemaFactory);
        CseContext.getInstance().setConsumerProviderManager(consumerProviderManager);
        CseContext.getInstance().setConsumerSchemaFactory(consumerSchemaFactory);
        CseContext.getInstance().setSchemaListenerManager(schemaListenerManager);
        Config config = new Config();
        Class<SimpleLoadBalanceHandler> cls = SimpleLoadBalanceHandler.class;
        config.getHandlerClassMap().put("simpleLB", cls);
        ProducerHandlerManager.INSTANCE.init(new Config());
        ConsumerHandlerManager.INSTANCE.init(config);
        ApplicationContext applicationContext = (ApplicationContext)Mockito.mock(ApplicationContext.class);
        Mockito.when((Object)applicationContext.getBean(Mockito.anyString())).thenReturn(null);
        BeanUtils.setContext((ApplicationContext)applicationContext);
        inited = true;
    }

    public UnitTestMeta() {
        new MockUp<ConsumerHandlerManager>(){

            @Mock
            public List<Handler> getOrCreate(String name) {
                return Collections.emptyList();
            }
        };
        new MockUp<ProducerHandlerManager>(){

            @Mock
            public List<Handler> getOrCreate(String name) {
                return Collections.emptyList();
            }
        };
        this.schemaLoader.setMicroserviceMetaManager(microserviceMetaManager);
    }

    public MicroserviceMetaManager getMicroserviceMetaManager() {
        return microserviceMetaManager;
    }

    public SchemaMeta getOrCreateSchemaMeta(Class<?> impl) {
        return this.getOrCreateSchemaMeta("app", "test", impl.getName(), impl);
    }

    public SchemaMeta getOrCreateSchemaMeta(String appId, String microserviceName, String schemaId, Class<?> impl) {
        String longName = appId + ":" + microserviceName;
        MicroserviceMeta microserviceMeta = microserviceMetaManager.getOrCreateMicroserviceMeta(longName);
        SchemaMeta schemaMeta = microserviceMeta.findSchemaMeta(schemaId);
        if (schemaMeta != null) {
            return schemaMeta;
        }
        Swagger swagger = UnitTestSwaggerUtils.generateSwagger(impl).getSwagger();
        return this.schemaLoader.registerSchema(microserviceMeta, schemaId, swagger);
    }

    static {
        UnitTestMeta.init();
    }
}

