/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.client.http;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.http.HttpClientOptions;
import org.apache.servicecomb.foundation.vertx.AddressResolverConfig;
import org.apache.servicecomb.foundation.vertx.VertxUtils;
import org.apache.servicecomb.foundation.vertx.client.ClientPoolFactory;
import org.apache.servicecomb.foundation.vertx.client.ClientPoolManager;
import org.apache.servicecomb.foundation.vertx.client.ClientVerticle;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClientPoolFactory;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClientWithContext;
import org.apache.servicecomb.serviceregistry.client.http.ClientPool;
import org.apache.servicecomb.serviceregistry.config.ServiceRegistryConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClientPool
implements ClientPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractClientPool.class);
    protected static final String SSL_KEY = "sc.consumer";
    private ClientPoolManager<HttpClientWithContext> clientMgr;

    public AbstractClientPool() {
        this.create();
    }

    @Override
    public HttpClientWithContext getClient() {
        return (HttpClientWithContext)this.clientMgr.findThreadBindClientPool();
    }

    @Override
    public void create() {
        VertxOptions vertxOptions = new VertxOptions();
        vertxOptions.setAddressResolverOptions(AddressResolverConfig.getAddressResover((String)SSL_KEY));
        Vertx vertx = VertxUtils.getOrCreateVertxByName((String)"registry", (VertxOptions)vertxOptions);
        HttpClientOptions httpClientOptions = this.createHttpClientOptions();
        this.clientMgr = new ClientPoolManager(vertx, (ClientPoolFactory)new HttpClientPoolFactory(httpClientOptions));
        DeploymentOptions deployOptions = VertxUtils.createClientDeployOptions(this.clientMgr, (int)ServiceRegistryConfig.INSTANCE.getWorkerPoolSize());
        try {
            VertxUtils.blockDeploy((Vertx)vertx, ClientVerticle.class, (DeploymentOptions)deployOptions);
        }
        catch (InterruptedException e) {
            LOGGER.error("deploy a registry verticle failed, {}", (Object)e.getMessage());
        }
    }
}

