/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.converter;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.models.Swagger;
import java.util.Map;
import org.apache.servicecomb.swagger.converter.Converter;
import org.apache.servicecomb.swagger.generator.core.utils.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class AbstractConverter
implements Converter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractConverter.class);

    protected abstract Map<String, Object> findVendorExtensions(Object var1);

    protected abstract JavaType doConvert(ClassLoader var1, String var2, Swagger var3, Object var4);

    @Override
    public JavaType convert(ClassLoader classLoader, String packageName, Swagger swagger, Object def) {
        Class<?> clsResult;
        TypeFactory typeFactory = TypeFactory.defaultInstance().withClassLoader(classLoader);
        Map<String, Object> vendorExtensions = this.findVendorExtensions(def);
        String canonical = (String)ClassUtils.getVendorExtension(vendorExtensions, "x-java-class");
        if (!StringUtils.isEmpty((Object)canonical) && (clsResult = ClassUtils.getClassByName(classLoader, canonical)) != null) {
            return typeFactory.constructType(clsResult);
        }
        JavaType result = this.doConvert(classLoader, packageName, swagger, def);
        String rawClassName = ClassUtils.getRawClassName(canonical);
        if (StringUtils.isEmpty((Object)rawClassName)) {
            return result;
        }
        try {
            JavaType rawType = typeFactory.constructFromCanonical(rawClassName);
            if (rawType.getRawClass().getTypeParameters().length > 0) {
                return typeFactory.constructFromCanonical(canonical);
            }
            return result;
        }
        catch (IllegalArgumentException e) {
            LOGGER.info("failed to load generic class {}, use {}. cause: {}.", new Object[]{rawClassName, result.getGenericSignature(), e.getMessage()});
            return result;
        }
    }
}

