/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.converter.model;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.models.ModelImpl;
import io.swagger.models.Swagger;
import org.apache.servicecomb.swagger.converter.ConverterMgr;
import org.apache.servicecomb.swagger.converter.model.AbstractModelConverter;
import org.apache.servicecomb.swagger.converter.property.MapPropertyConverter;
import org.apache.servicecomb.swagger.generator.core.utils.ClassUtils;
import org.springframework.util.StringUtils;

public class ModelImplConverter
extends AbstractModelConverter {
    @Override
    public JavaType doConvert(ClassLoader classLoader, String packageName, Swagger swagger, Object model) {
        ModelImpl modelImpl = (ModelImpl)model;
        JavaType javaType = ConverterMgr.findJavaType(modelImpl.getType(), modelImpl.getFormat());
        if (javaType != null) {
            return javaType;
        }
        if (modelImpl.getReference() != null) {
            return ConverterMgr.findByRef(classLoader, packageName, swagger, modelImpl.getReference());
        }
        if (modelImpl.getAdditionalProperties() != null) {
            return MapPropertyConverter.findJavaType(classLoader, packageName, swagger, modelImpl.getAdditionalProperties());
        }
        if ("object".equals(modelImpl.getType()) && modelImpl.getProperties() == null && modelImpl.getName() == null) {
            return TypeFactory.defaultInstance().constructType(Object.class);
        }
        return this.getOrCreateType(classLoader, packageName, swagger, modelImpl);
    }

    protected String getOrCreateClassName(String packageName, ModelImpl modelImpl) throws Error {
        String canonical = (String)ClassUtils.getVendorExtension(this.findVendorExtensions(modelImpl), "x-java-class");
        if (!StringUtils.isEmpty((Object)canonical)) {
            return canonical;
        }
        if (packageName == null) {
            throw new IllegalStateException("packageName should not be null");
        }
        return packageName + "." + modelImpl.getName();
    }

    protected JavaType getOrCreateType(ClassLoader classLoader, String packageName, Swagger swagger, ModelImpl modelImpl) throws Error {
        String clsName = this.getOrCreateClassName(packageName, modelImpl);
        clsName = ClassUtils.correctClassName(clsName);
        Class<?> cls = ClassUtils.getOrCreateClass(classLoader, packageName, swagger, modelImpl.getProperties(), clsName);
        return TypeFactory.defaultInstance().constructType(cls);
    }
}

