/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.extend;

import com.fasterxml.jackson.databind.JavaType;
import com.google.common.annotations.VisibleForTesting;
import io.swagger.converter.ModelConverter;
import io.swagger.converter.ModelConverterContext;
import io.swagger.jackson.ModelResolver;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import io.swagger.util.Json;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.servicecomb.foundation.common.exceptions.ServiceCombException;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.swagger.converter.property.StringPropertyConverter;
import org.apache.servicecomb.swagger.extend.property.creator.ByteArrayPropertyCreator;
import org.apache.servicecomb.swagger.extend.property.creator.BytePropertyCreator;
import org.apache.servicecomb.swagger.extend.property.creator.InputStreamPropertyCreator;
import org.apache.servicecomb.swagger.extend.property.creator.PartPropertyCreator;
import org.apache.servicecomb.swagger.extend.property.creator.PropertyCreator;
import org.apache.servicecomb.swagger.extend.property.creator.ShortPropertyCreator;
import org.springframework.util.StringUtils;

public class ModelResolverExt
extends ModelResolver {
    private Map<Class<?>, PropertyCreator> propertyCreatorMap = new HashMap();

    public ModelResolverExt() {
        super(Json.mapper());
        this.addPropertyCreator(new BytePropertyCreator());
        this.addPropertyCreator(new ShortPropertyCreator());
        this.addPropertyCreator(new ByteArrayPropertyCreator());
        this.addPropertyCreator(new InputStreamPropertyCreator());
        this.addPropertyCreator(new PartPropertyCreator());
        this.loadPropertyCreators();
    }

    private void addPropertyCreator(PropertyCreator creator) {
        for (Class<?> cls : creator.classes()) {
            this.propertyCreatorMap.put(cls, creator);
        }
    }

    private void loadPropertyCreators() {
        SPIServiceUtils.getAllService(PropertyCreator.class).forEach(this::addPropertyCreator);
    }

    @VisibleForTesting
    protected void setType(JavaType type, Map<String, Object> vendorExtensions) {
        vendorExtensions.put("x-java-class", type.toCanonical());
    }

    private void checkType(JavaType type) {
        Class keyTypeClass;
        if (type.getRawClass().isPrimitive() || this.propertyCreatorMap.containsKey(type.getRawClass()) || String.class.equals((Object)type.getRawClass())) {
            return;
        }
        String msg = "Must be a concrete type.";
        if (type.isMapLikeType() && !String.class.equals((Object)(keyTypeClass = type.getKeyType().getRawClass()))) {
            throw new Error("Type of key in map must be string, but got " + keyTypeClass.getName());
        }
        if (type.isContainerType()) {
            this.checkType(type.getContentType());
            return;
        }
        if (type.getRawClass().isInterface()) {
            throw new ServiceCombException(type.getTypeName() + " is interface. " + msg);
        }
        if (Modifier.isAbstract(type.getRawClass().getModifiers())) {
            throw new ServiceCombException(type.getTypeName() + " is abstract class. " + msg);
        }
    }

    public Model resolve(JavaType type, ModelConverterContext context, Iterator<ModelConverter> next) {
        if (this.propertyCreatorMap.containsKey(type.getRawClass())) {
            return null;
        }
        Model model = super.resolve(type, context, next);
        if (model == null) {
            return null;
        }
        this.checkType(type);
        if (ModelImpl.class.isInstance(model) && !StringUtils.isEmpty((Object)((ModelImpl)model).getName())) {
            this.setType(type, model.getVendorExtensions());
        }
        return model;
    }

    public Property resolveProperty(JavaType propType, ModelConverterContext context, Annotation[] annotations, Iterator<ModelConverter> next) {
        this.checkType(propType);
        PropertyCreator creator = this.propertyCreatorMap.get(propType.getRawClass());
        if (creator != null) {
            return creator.createProperty();
        }
        Property property = super.resolveProperty(propType, context, annotations, next);
        if (StringProperty.class.isInstance(property) && StringPropertyConverter.isEnum((StringProperty)property)) {
            this.setType(propType, property.getVendorExtensions());
        }
        return property;
    }
}

