/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.ResponseHeader;
import io.swagger.annotations.SwaggerDefinition;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.apache.servicecomb.foundation.common.RegisterManager;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.swagger.extend.annotations.RawJsonRequestBody;
import org.apache.servicecomb.swagger.extend.annotations.ResponseHeaders;
import org.apache.servicecomb.swagger.generator.core.AnnotationProcessorManager;
import org.apache.servicecomb.swagger.generator.core.ClassAnnotationProcessor;
import org.apache.servicecomb.swagger.generator.core.CommonParameterTypeProcessor;
import org.apache.servicecomb.swagger.generator.core.DefaultParameterProcessor;
import org.apache.servicecomb.swagger.generator.core.MethodAnnotationProcessor;
import org.apache.servicecomb.swagger.generator.core.ParameterAnnotationProcessor;
import org.apache.servicecomb.swagger.generator.core.ParameterTypeProcessor;
import org.apache.servicecomb.swagger.generator.core.ResponseTypeProcessor;
import org.apache.servicecomb.swagger.generator.core.SwaggerGeneratorContext;
import org.apache.servicecomb.swagger.generator.core.processor.annotation.ApiImplicitParamClassProcessor;
import org.apache.servicecomb.swagger.generator.core.processor.annotation.ApiImplicitParamMethodProcessor;
import org.apache.servicecomb.swagger.generator.core.processor.annotation.ApiImplicitParamsClassProcessor;
import org.apache.servicecomb.swagger.generator.core.processor.annotation.ApiImplicitParamsMethodProcessor;
import org.apache.servicecomb.swagger.generator.core.processor.annotation.ApiOperationProcessor;
import org.apache.servicecomb.swagger.generator.core.processor.annotation.ApiProcessor;
import org.apache.servicecomb.swagger.generator.core.processor.annotation.ApiResponseClassProcessor;
import org.apache.servicecomb.swagger.generator.core.processor.annotation.ApiResponseMethodProcessor;
import org.apache.servicecomb.swagger.generator.core.processor.annotation.ApiResponsesClassProcessor;
import org.apache.servicecomb.swagger.generator.core.processor.annotation.ApiResponsesMethodProcessor;
import org.apache.servicecomb.swagger.generator.core.processor.annotation.ResponseHeaderProcessor;
import org.apache.servicecomb.swagger.generator.core.processor.annotation.ResponseHeadersProcessor;
import org.apache.servicecomb.swagger.generator.core.processor.annotation.SwaggerDefinitionProcessor;
import org.apache.servicecomb.swagger.generator.core.processor.parametertype.RawJsonRequestBodyProcessor;
import org.apache.servicecomb.swagger.generator.core.processor.response.DefaultResponseTypeProcessor;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.util.StringValueResolver;

public abstract class AbstractSwaggerGeneratorContext
implements SwaggerGeneratorContext,
EmbeddedValueResolverAware {
    protected StringValueResolver stringValueResolver;
    protected AnnotationProcessorManager<ClassAnnotationProcessor> classAnnotationMgr = new AnnotationProcessorManager(AnnotationProcessorManager.AnnotationType.CLASS);
    protected AnnotationProcessorManager<MethodAnnotationProcessor> methodAnnotationMgr = new AnnotationProcessorManager(AnnotationProcessorManager.AnnotationType.METHOD);
    protected AnnotationProcessorManager<ParameterAnnotationProcessor> parameterAnnotationMgr = new AnnotationProcessorManager(AnnotationProcessorManager.AnnotationType.PARAMETER);
    protected RegisterManager<Type, ParameterTypeProcessor> parameterTypeProcessorMgr = new RegisterManager("parameter type processor mgr");
    protected DefaultParameterProcessor defaultParameterProcessor;
    protected RegisterManager<Type, ResponseTypeProcessor> responseTypeProcessorMgr = new RegisterManager("response type processor mgr");
    protected ResponseTypeProcessor defaultResponseTypeProcessor = new DefaultResponseTypeProcessor();

    public AbstractSwaggerGeneratorContext() {
        this.initClassAnnotationMgr();
        this.initMethodAnnotationMgr();
        this.initParameterAnnotationMgr();
        this.initParameterTypeProcessorMgr();
        this.initDefaultParameterProcessor();
        this.initResponseTypeProcessorMgr();
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.stringValueResolver = resolver;
    }

    @Override
    public String resolveStringValue(String strVal) {
        if (this.stringValueResolver == null) {
            return strVal;
        }
        return this.stringValueResolver.resolveStringValue(strVal);
    }

    protected void initClassAnnotationMgr() {
        this.classAnnotationMgr.register(Api.class, new ApiProcessor());
        this.classAnnotationMgr.register(SwaggerDefinition.class, new SwaggerDefinitionProcessor());
        this.classAnnotationMgr.register(ApiImplicitParams.class, new ApiImplicitParamsClassProcessor());
        this.classAnnotationMgr.register(ApiImplicitParam.class, new ApiImplicitParamClassProcessor());
        this.classAnnotationMgr.register(ApiResponses.class, new ApiResponsesClassProcessor());
        this.classAnnotationMgr.register(ApiResponse.class, new ApiResponseClassProcessor());
    }

    protected void initMethodAnnotationMgr() {
        this.methodAnnotationMgr.register(ApiOperation.class, new ApiOperationProcessor());
        this.methodAnnotationMgr.register(ApiImplicitParams.class, new ApiImplicitParamsMethodProcessor());
        this.methodAnnotationMgr.register(ApiImplicitParam.class, new ApiImplicitParamMethodProcessor());
        this.methodAnnotationMgr.register(ApiResponses.class, new ApiResponsesMethodProcessor());
        this.methodAnnotationMgr.register(ApiResponse.class, new ApiResponseMethodProcessor());
        this.methodAnnotationMgr.register(ResponseHeaders.class, new ResponseHeadersProcessor());
        this.methodAnnotationMgr.register(ResponseHeader.class, new ResponseHeaderProcessor());
    }

    protected void initParameterAnnotationMgr() {
        this.parameterAnnotationMgr.register(RawJsonRequestBody.class, new RawJsonRequestBodyProcessor());
    }

    protected void initParameterTypeProcessorMgr() {
        SPIServiceUtils.getAllService(CommonParameterTypeProcessor.class).forEach(p -> this.parameterTypeProcessorMgr.register(p.getParameterType(), p));
    }

    protected void initDefaultParameterProcessor() {
    }

    protected void initResponseTypeProcessorMgr() {
        SPIServiceUtils.getAllService(ResponseTypeProcessor.class).forEach(p -> this.responseTypeProcessorMgr.register(p.getResponseType(), p));
    }

    public void setDefaultParamProcessor(DefaultParameterProcessor defaultParamProcessor) {
        this.defaultParameterProcessor = defaultParamProcessor;
    }

    @Override
    public ClassAnnotationProcessor findClassAnnotationProcessor(Class<? extends Annotation> annotationType) {
        return this.classAnnotationMgr.findProcessor(annotationType);
    }

    @Override
    public MethodAnnotationProcessor findMethodAnnotationProcessor(Class<? extends Annotation> annotationType) {
        return this.methodAnnotationMgr.findProcessor(annotationType);
    }

    @Override
    public ParameterAnnotationProcessor findParameterAnnotationProcessor(Class<? extends Annotation> annotationType) {
        return this.parameterAnnotationMgr.findProcessor(annotationType);
    }

    @Override
    public ParameterTypeProcessor findParameterTypeProcessor(Type type) {
        return (ParameterTypeProcessor)this.parameterTypeProcessorMgr.findValue((Object)type);
    }

    @Override
    public DefaultParameterProcessor getDefaultParamProcessor() {
        return this.defaultParameterProcessor;
    }

    @Override
    public ResponseTypeProcessor findResponseTypeProcessor(Type responseType) {
        ResponseTypeProcessor processor = (ResponseTypeProcessor)this.responseTypeProcessorMgr.findValue((Object)responseType);
        if (processor == null) {
            processor = this.defaultResponseTypeProcessor;
        }
        return processor;
    }
}

