/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core.unittest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.swagger.models.Swagger;
import io.swagger.util.Yaml;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.servicecomb.swagger.generator.core.CompositeSwaggerGeneratorContext;
import org.apache.servicecomb.swagger.generator.core.SwaggerGenerator;
import org.apache.servicecomb.swagger.generator.core.SwaggerGeneratorContext;
import org.apache.servicecomb.swagger.generator.core.unittest.SwaggerGeneratorForTest;
import org.junit.Assert;

public final class UnitTestSwaggerUtils {
    private static ObjectWriter writer = Yaml.pretty();
    private static CompositeSwaggerGeneratorContext compositeContext = new CompositeSwaggerGeneratorContext();

    private UnitTestSwaggerUtils() {
    }

    public static SwaggerGenerator generateSwagger(Class<?> cls) {
        SwaggerGeneratorContext context = compositeContext.selectContext(cls);
        SwaggerGenerator generator = new SwaggerGenerator(context, cls);
        generator.generate();
        return generator;
    }

    public static String loadExpect(String resPath) {
        URL url = Thread.currentThread().getContextClassLoader().getResource(resPath);
        if (url == null) {
            return "can not found res " + resPath;
        }
        try {
            return IOUtils.toString((URL)url);
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }

    public static String pretty(Swagger swagger) {
        try {
            return writer.writeValueAsString((Object)swagger);
        }
        catch (JsonProcessingException e) {
            throw new Error(e);
        }
    }

    public static Swagger parse(String content) {
        try {
            return (Swagger)Yaml.mapper().readValue(content, Swagger.class);
        }
        catch (Exception e) {
            return new Swagger();
        }
    }

    public static SwaggerGenerator testSwagger(String resPath, SwaggerGeneratorContext context, Class<?> cls, String ... methods) {
        SwaggerGeneratorForTest generator = new SwaggerGeneratorForTest(context, cls);
        generator.setClassLoader(new ClassLoader(){});
        generator.replaceMethods(methods);
        Swagger swagger = generator.generate();
        String expectSchema = UnitTestSwaggerUtils.loadExpect(resPath);
        Swagger expectSwagger = UnitTestSwaggerUtils.parse(expectSchema);
        String schema = UnitTestSwaggerUtils.pretty(swagger);
        swagger = UnitTestSwaggerUtils.parse(schema);
        if (swagger != null && !swagger.equals((Object)expectSwagger)) {
            Assert.assertEquals((Object)expectSchema, (Object)schema);
        }
        return generator;
    }

    public static Throwable getException(SwaggerGeneratorContext context, Class<?> cls, String ... methods) {
        try {
            SwaggerGeneratorForTest generator = new SwaggerGeneratorForTest(context, cls);
            generator.replaceMethods(methods);
            generator.generate();
        }
        catch (Throwable e) {
            return e;
        }
        Assert.assertEquals((Object)"not allowed run to here", (Object)"run to here");
        return null;
    }

    public static void testException(String expectMsgLevel1, String expectMsgLevel2, SwaggerGeneratorContext context, Class<?> cls, String ... methods) {
        Throwable exception = UnitTestSwaggerUtils.getException(context, cls, methods);
        Assert.assertEquals((Object)expectMsgLevel1, (Object)exception.getMessage());
        Assert.assertEquals((Object)expectMsgLevel2, (Object)exception.getCause().getMessage());
    }

    public static void testException(String expectMsg, SwaggerGeneratorContext context, Class<?> cls, String ... methods) {
        Throwable exception = UnitTestSwaggerUtils.getException(context, cls, methods);
        Assert.assertEquals((Object)expectMsg, (Object)exception.getMessage());
    }
}

