/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core.utils;

import com.fasterxml.jackson.databind.JavaType;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.Property;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.lang.model.SourceVersion;
import org.apache.servicecomb.common.javassist.ClassConfig;
import org.apache.servicecomb.common.javassist.JavassistUtils;
import org.apache.servicecomb.common.javassist.MethodConfig;
import org.apache.servicecomb.swagger.converter.ConverterMgr;
import org.apache.servicecomb.swagger.generator.core.OperationGenerator;
import org.apache.servicecomb.swagger.generator.core.SwaggerConst;
import org.apache.servicecomb.swagger.generator.core.SwaggerGenerator;
import org.springframework.util.StringUtils;

public final class ClassUtils {
    private ClassUtils() {
    }

    public static Class<?> getClassByName(ClassLoader classLoader, String clsName) {
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        try {
            return classLoader.loadClass(clsName);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Class<?> getOrCreateClass(ClassLoader classLoader, String packageName, Swagger swagger, Map<String, Property> properties, String clsName) {
        Class cls = ClassUtils.getClassByName(classLoader, clsName);
        if (cls != null) {
            return cls;
        }
        ClassConfig classConfig = new ClassConfig();
        classConfig.setClassName(clsName);
        if (null != properties) {
            for (Map.Entry<String, Property> entry : properties.entrySet()) {
                JavaType propertyJavaType = ConverterMgr.findJavaType(classLoader, packageName, swagger, entry.getValue());
                classConfig.addField(entry.getKey(), propertyJavaType);
            }
        }
        cls = JavassistUtils.createClass((ClassLoader)classLoader, (ClassConfig)classConfig);
        return cls;
    }

    public static Class<?> getOrCreateBodyClass(OperationGenerator operationGenerator, List<BodyParameter> bodyParameters) {
        SwaggerGenerator swaggerGenerator = operationGenerator.getSwaggerGenerator();
        Method method = operationGenerator.getProviderMethod();
        String clsName = swaggerGenerator.ensureGetPackageName() + "." + method.getName() + "Body";
        Class<?> cls = ClassUtils.getClassByName(swaggerGenerator.getClassLoader(), clsName);
        if (cls != null) {
            return cls;
        }
        ClassConfig classConfig = new ClassConfig();
        classConfig.setClassName(clsName);
        for (BodyParameter bp : bodyParameters) {
            JavaType javaType = ConverterMgr.findJavaType(swaggerGenerator.getClassLoader(), swaggerGenerator.ensureGetPackageName(), swaggerGenerator.getSwagger(), bp);
            classConfig.addField(bp.getName(), javaType);
        }
        return JavassistUtils.createClass((ClassLoader)swaggerGenerator.getClassLoader(), (ClassConfig)classConfig);
    }

    public static boolean hasAnnotation(Class<?> cls, Class<? extends Annotation> annotation) {
        if (cls.getAnnotation(annotation) != null) {
            return true;
        }
        for (Method method : cls.getMethods()) {
            if (method.getAnnotation(annotation) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isRawJsonType(Parameter param) {
        Object rawJson = param.getVendorExtensions().get("x-raw-json");
        if (Boolean.class.isInstance(rawJson)) {
            return (Boolean)rawJson;
        }
        return false;
    }

    public static Class<?> getJavaInterface(Swagger swagger) {
        return ClassUtils.getClassByVendorExtensions(null, swagger.getInfo().getVendorExtensions(), "x-java-interface");
    }

    public static Class<?> getClassByVendorExtensions(ClassLoader classLoader, Map<String, Object> vendorExtensions, String clsKey) {
        String clsName = (String)ClassUtils.getVendorExtension(vendorExtensions, clsKey);
        if (StringUtils.isEmpty((Object)clsName)) {
            return null;
        }
        return ClassUtils.getClassByName(classLoader, clsName);
    }

    public static String getRawClassName(String canonical) {
        if (StringUtils.isEmpty((Object)canonical)) {
            return null;
        }
        int idx = canonical.indexOf("<");
        if (idx == 0) {
            throw new IllegalStateException("Invalid class canonical: " + canonical);
        }
        if (idx < 0) {
            return canonical;
        }
        return canonical.substring(0, idx);
    }

    public static <T> T getVendorExtension(Map<String, Object> vendorExtensions, String key) {
        if (vendorExtensions == null) {
            return null;
        }
        return (T)vendorExtensions.get(key);
    }

    public static Class<?> getOrCreateInterface(SwaggerGenerator generator) {
        return ClassUtils.getOrCreateInterface(generator.getSwagger(), generator.getClassLoader(), generator.ensureGetPackageName());
    }

    public static Class<?> getOrCreateInterface(Swagger swagger, ClassLoader classLoader, String packageName) {
        String intfName = (String)swagger.getInfo().getVendorExtensions().get("x-java-interface");
        Class<?> intf = ClassUtils.getClassByName(classLoader, intfName);
        if (intf != null) {
            return intf;
        }
        if (packageName == null) {
            int idx = intfName.lastIndexOf(".");
            packageName = idx == -1 ? "" : intfName.substring(0, idx);
        }
        return ClassUtils.createInterface(swagger, classLoader, packageName, intfName);
    }

    private static Class<?> createInterface(Swagger swagger, ClassLoader classLoader, String packageName, String intfName) {
        ClassConfig classConfig = new ClassConfig();
        classConfig.setClassName(intfName);
        classConfig.setIntf(true);
        for (Path path : swagger.getPaths().values()) {
            for (Operation operation : path.getOperations()) {
                String opPackageName = packageName + "." + operation.getOperationId();
                Response result = (Response)operation.getResponses().get(SwaggerConst.SUCCESS_KEY);
                JavaType resultJavaType = ConverterMgr.findJavaType(classLoader, opPackageName, swagger, result.getSchema());
                MethodConfig methodConfig = new MethodConfig();
                methodConfig.setName(operation.getOperationId());
                methodConfig.setResult(resultJavaType);
                for (Parameter parameter : operation.getParameters()) {
                    String paramName = parameter.getName();
                    paramName = ClassUtils.correctMethodParameterName(paramName);
                    JavaType paramJavaType = ConverterMgr.findJavaType(classLoader, opPackageName, swagger, parameter);
                    methodConfig.addParameter(paramName, paramJavaType);
                }
                classConfig.addMethod(methodConfig);
            }
        }
        return JavassistUtils.createClass((ClassLoader)classLoader, (ClassConfig)classConfig);
    }

    public static String correctMethodParameterName(String paramName) {
        if (SourceVersion.isName(paramName)) {
            return paramName;
        }
        StringBuffer newParam = new StringBuffer();
        for (int index = 0; index < paramName.length(); ++index) {
            char tempChar = paramName.charAt(index);
            if (Character.isJavaIdentifierPart(tempChar)) {
                newParam.append(paramName.charAt(index));
                continue;
            }
            if (tempChar != '.' && tempChar != '-') continue;
            newParam.append('_');
        }
        return newParam.toString();
    }

    public static String correctClassName(String name) {
        if (SourceVersion.isIdentifier(name) && !SourceVersion.isKeyword(name)) {
            return name;
        }
        CharSequence[] parts = name.split("\\.", -1);
        for (int idx = 0; idx < parts.length; ++idx) {
            String part = parts[idx];
            if (part.isEmpty()) {
                parts[idx] = "_";
                continue;
            }
            if (Character.isDigit((part = part.replaceAll("[<>-]", "_").replace("[", "array_")).charAt(0)) || SourceVersion.isKeyword(part)) {
                part = "_" + part;
            }
            parts[idx] = part;
        }
        return String.join((CharSequence)".", parts);
    }
}

