/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core.utils;

import com.fasterxml.jackson.databind.ser.std.MapProperty;
import io.swagger.converter.ModelConverters;
import io.swagger.models.Model;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.PropertyBuilder;
import io.swagger.models.properties.RefProperty;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.swagger.generator.core.OperationGenerator;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;

public final class ParamUtils {
    private static DefaultParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();

    private ParamUtils() {
    }

    public static String getParameterName(String existName, Method method, int paramIdx) {
        if (StringUtils.isEmpty((CharSequence)existName)) {
            existName = ParamUtils.getParameterName(method, paramIdx);
        }
        return existName;
    }

    public static String getParameterName(Method method, int paramIdx) {
        MethodParameter methodParameter = new MethodParameter(method, paramIdx);
        methodParameter.initParameterNameDiscovery((ParameterNameDiscoverer)parameterNameDiscoverer);
        String paramName = methodParameter.getParameterName();
        if (paramName == null) {
            paramName = "arg" + paramIdx;
        }
        return paramName;
    }

    public static Type getGenericParameterType(Method method, int paramIdx) {
        return method.getGenericParameterTypes()[paramIdx];
    }

    public static String generateBodyParameterName(Method method) {
        return method.getName() + "Body";
    }

    public static BodyParameter createBodyParameter(OperationGenerator operationGenerator, int paramIdx) {
        Method method = operationGenerator.getProviderMethod();
        String paramName = ParamUtils.getParameterName(method, paramIdx);
        Type paramType = ParamUtils.getGenericParameterType(method, paramIdx);
        return ParamUtils.createBodyParameter(operationGenerator.getSwagger(), paramName, paramType);
    }

    public static BodyParameter createBodyParameter(Swagger swagger, String paramName, Type paramType) {
        ParamUtils.addDefinitions(swagger, paramType);
        Property property = ModelConverters.getInstance().readAsProperty(paramType);
        Model model = PropertyBuilder.toModel((Property)property);
        BodyParameter bodyParameter = new BodyParameter();
        bodyParameter.setName(paramName);
        bodyParameter.setSchema(model);
        return bodyParameter;
    }

    public static void addDefinitions(Swagger swagger, Type paramType) {
        Map models = ModelConverters.getInstance().readAll(paramType);
        for (Map.Entry entry : models.entrySet()) {
            swagger.addDefinition((String)entry.getKey(), (Model)entry.getValue());
        }
    }

    public static void setParameterType(Swagger swagger, Method method, int paramIdx, AbstractSerializableParameter<?> parameter) {
        Type paramType = ParamUtils.getGenericParameterType(method, paramIdx);
        ParamUtils.addDefinitions(swagger, paramType);
        Property property = ModelConverters.getInstance().readAsProperty(paramType);
        if (ParamUtils.isComplexProperty(property)) {
            String msg = String.format("not allow complex type for %s parameter, method=%s:%s, paramIdx=%d, type=%s", parameter.getIn(), method.getDeclaringClass().getName(), method.getName(), paramIdx, paramType.getTypeName());
            throw new Error(msg);
        }
        parameter.setProperty(property);
    }

    public static boolean isComplexProperty(Property property) {
        if (RefProperty.class.isInstance(property) || ObjectProperty.class.isInstance(property) || MapProperty.class.isInstance(property)) {
            return true;
        }
        if (ArrayProperty.class.isInstance(property)) {
            return ParamUtils.isComplexProperty(((ArrayProperty)property).getItems());
        }
        return false;
    }

    public static int findParameterByName(String name, List<Parameter> parameterList) {
        for (int idx = 0; idx < parameterList.size(); ++idx) {
            Parameter parameter = parameterList.get(idx);
            if (!name.equals(parameter.getName())) continue;
            return idx;
        }
        return -1;
    }

    public static boolean isRealBodyParameter(Parameter parameter) {
        return BodyParameter.class.getName().equals(parameter.getClass().getName());
    }
}

