/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.pojo.extend.parameter;

import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.RefModel;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.PropertyBuilder;
import io.swagger.models.properties.RefProperty;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.apache.servicecomb.swagger.generator.core.OperationGenerator;
import org.apache.servicecomb.swagger.generator.core.utils.ParamUtils;

public class PendingBodyParameter
extends BodyParameter {
    private OperationGenerator operationGenerator;
    private Property property;
    private Type type;

    public void setOperationGenerator(OperationGenerator operationGenerator) {
        this.operationGenerator = operationGenerator;
    }

    public Property getProperty() {
        return this.property;
    }

    public void setProperty(Property property) {
        this.property = property;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Method getMethod() {
        return this.operationGenerator.getProviderMethod();
    }

    public BodyParameter createBodyParameter(String paramName) {
        String modelType = ParamUtils.generateBodyParameterName(this.operationGenerator.getProviderMethod());
        RefModel model = this.toRefModel(modelType);
        BodyParameter bodyParameter = new BodyParameter();
        bodyParameter.setName(paramName);
        bodyParameter.setSchema((Model)model);
        return bodyParameter;
    }

    private RefModel toRefModel(String modelType) {
        if (RefProperty.class.isInstance(this.property)) {
            return (RefModel)PropertyBuilder.toModel((Property)this.property);
        }
        ModelImpl modelImpl = new ModelImpl();
        modelImpl.setType("object");
        modelImpl.setName(this.name);
        modelImpl.addProperty(this.name, this.property);
        this.operationGenerator.getSwagger().addDefinition(modelType, (Model)modelImpl);
        RefModel refModel = new RefModel();
        refModel.setReference("#/definitions/" + modelType);
        return refModel;
    }
}

