/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.engine;

import io.swagger.annotations.ApiOperation;
import io.swagger.models.Swagger;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.foundation.common.utils.BeanUtils;
import org.apache.servicecomb.foundation.common.utils.ReflectUtils;
import org.apache.servicecomb.swagger.engine.SwaggerConsumer;
import org.apache.servicecomb.swagger.engine.SwaggerConsumerOperation;
import org.apache.servicecomb.swagger.engine.SwaggerProducer;
import org.apache.servicecomb.swagger.engine.SwaggerProducerOperation;
import org.apache.servicecomb.swagger.generator.core.SwaggerGenerator;
import org.apache.servicecomb.swagger.generator.core.unittest.UnitTestSwaggerUtils;
import org.apache.servicecomb.swagger.generator.core.utils.ClassUtils;
import org.apache.servicecomb.swagger.invocation.arguments.consumer.ConsumerArgumentsMapper;
import org.apache.servicecomb.swagger.invocation.arguments.consumer.ConsumerArgumentsMapperFactory;
import org.apache.servicecomb.swagger.invocation.arguments.producer.ProducerArgumentsMapper;
import org.apache.servicecomb.swagger.invocation.arguments.producer.ProducerArgumentsMapperFactory;
import org.apache.servicecomb.swagger.invocation.converter.ConverterMgr;
import org.apache.servicecomb.swagger.invocation.response.ResponseMapperFactorys;
import org.apache.servicecomb.swagger.invocation.response.consumer.ConsumerResponseMapper;
import org.apache.servicecomb.swagger.invocation.response.consumer.ConsumerResponseMapperFactory;
import org.apache.servicecomb.swagger.invocation.response.producer.ProducerResponseMapper;
import org.apache.servicecomb.swagger.invocation.response.producer.ProducerResponseMapperFactory;
import org.springframework.stereotype.Component;

@Component
public class SwaggerEnvironment {
    @Inject
    private ProducerArgumentsMapperFactory producerArgumentsFactory;
    private ResponseMapperFactorys<ProducerResponseMapper> producerResponseMapperFactorys = new ResponseMapperFactorys(ProducerResponseMapperFactory.class);
    @Inject
    private ConsumerArgumentsMapperFactory consumerArgumentsFactory;
    private ResponseMapperFactorys<ConsumerResponseMapper> consumerResponseMapperFactorys = new ResponseMapperFactorys(ConsumerResponseMapperFactory.class);

    @Inject
    public void setConverterMgr(ConverterMgr converterMgr) {
        this.consumerResponseMapperFactorys.setConverterMgr(converterMgr);
        this.producerResponseMapperFactorys.setConverterMgr(converterMgr);
    }

    public ProducerArgumentsMapperFactory getProducerArgumentsFactory() {
        return this.producerArgumentsFactory;
    }

    public void setProducerArgumentsFactory(ProducerArgumentsMapperFactory producerArgumentsFactory) {
        this.producerArgumentsFactory = producerArgumentsFactory;
    }

    public ConsumerArgumentsMapperFactory getConsumerArgumentsFactory() {
        return this.consumerArgumentsFactory;
    }

    public void setConsumerArgumentsFactory(ConsumerArgumentsMapperFactory consumerArgumentsFactory) {
        this.consumerArgumentsFactory = consumerArgumentsFactory;
    }

    public SwaggerConsumer createConsumer(Class<?> consumerIntf) {
        return this.createConsumer(consumerIntf, consumerIntf);
    }

    public SwaggerConsumer createConsumer(Class<?> consumerIntf, Class<?> swaggerIntf) {
        SwaggerConsumer consumer = new SwaggerConsumer();
        consumer.setConsumerIntf(consumerIntf);
        consumer.setSwaggerIntf(swaggerIntf);
        for (Method consumerMethod : consumerIntf.getMethods()) {
            String swaggerMethodName = this.findSwaggerMethodName(consumerMethod);
            Method swaggerMethod = ReflectUtils.findMethod(swaggerIntf, (String)swaggerMethodName);
            if (swaggerMethod == null) {
                String msg = String.format("consumer method %s:%s not exist in swagger.", consumerIntf.getName(), consumerMethod.getName());
                throw new Error(msg);
            }
            ConsumerArgumentsMapper argsMapper = (ConsumerArgumentsMapper)this.consumerArgumentsFactory.createArgumentsMapper(swaggerMethod, consumerMethod);
            ConsumerResponseMapper responseMapper = this.consumerResponseMapperFactorys.createResponseMapper(swaggerMethod.getGenericReturnType(), consumerMethod.getGenericReturnType());
            SwaggerConsumerOperation op = new SwaggerConsumerOperation();
            op.setName(consumerMethod.getName());
            op.setConsumerMethod(consumerMethod);
            op.setSwaggerMethod(swaggerMethod);
            op.setArgumentsMapper(argsMapper);
            op.setResponseMapper(responseMapper);
            consumer.addOperation(op);
        }
        return consumer;
    }

    protected String findSwaggerMethodName(Method consumerMethod) {
        ApiOperation apiOperationAnnotation = consumerMethod.getAnnotation(ApiOperation.class);
        if (apiOperationAnnotation == null || StringUtils.isEmpty((CharSequence)apiOperationAnnotation.nickname())) {
            return consumerMethod.getName();
        }
        return apiOperationAnnotation.nickname();
    }

    public SwaggerProducer createProducer(Object producerInstance, Swagger swagger) {
        Class producerCls = BeanUtils.getImplClassFromBean((Object)producerInstance);
        Map<String, Method> visibleProducerMethods = this.retrieveVisibleMethods(producerCls);
        Class swaggerIntf = ClassUtils.getOrCreateInterface((Swagger)swagger, null, null);
        SwaggerProducer producer = new SwaggerProducer();
        producer.setProducerCls(producerCls);
        producer.setSwaggerIntf(swaggerIntf);
        for (Method swaggerMethod : swaggerIntf.getMethods()) {
            String methodName = swaggerMethod.getName();
            Method producerMethod = visibleProducerMethods.getOrDefault(methodName, null);
            if (producerMethod == null) {
                String msg = String.format("swagger method %s:%s not exist in producer.", swaggerIntf.getClass().getName(), methodName);
                throw new Error(msg);
            }
            ProducerArgumentsMapper argsMapper = (ProducerArgumentsMapper)this.producerArgumentsFactory.createArgumentsMapper(swaggerMethod, producerMethod);
            ProducerResponseMapper responseMapper = this.producerResponseMapperFactorys.createResponseMapper(swaggerMethod.getGenericReturnType(), producerMethod.getGenericReturnType());
            SwaggerProducerOperation op = new SwaggerProducerOperation();
            op.setName(methodName);
            op.setProducerClass(producerCls);
            op.setProducerInstance(producerInstance);
            op.setProducerMethod(producerMethod);
            op.setSwaggerMethod(swaggerMethod);
            op.setArgumentsMapper(argsMapper);
            op.setResponseMapper(responseMapper);
            producer.addOperation(op);
        }
        return producer;
    }

    public SwaggerProducer createProducer(Object producerInstance) {
        Class producerCls = BeanUtils.getImplClassFromBean((Object)producerInstance);
        SwaggerGenerator producerGenerator = UnitTestSwaggerUtils.generateSwagger((Class)producerCls);
        Swagger swagger = producerGenerator.getSwagger();
        return this.createProducer(producerInstance, swagger);
    }

    private Map<String, Method> retrieveVisibleMethods(Class<?> clazz) {
        HashMap<String, Method> visibleMethods = new HashMap<String, Method>();
        for (Method method : clazz.getMethods()) {
            String methodName = method.getName();
            ApiOperation apiOperationAnnotation = method.getAnnotation(ApiOperation.class);
            if (apiOperationAnnotation != null) {
                if (apiOperationAnnotation.hidden()) continue;
                if (StringUtils.isNotEmpty((CharSequence)apiOperationAnnotation.nickname())) {
                    methodName = apiOperationAnnotation.nickname();
                }
            }
            visibleMethods.put(methodName, method);
        }
        return visibleMethods;
    }
}

