/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.invocation.arguments.consumer;

import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.servicecomb.swagger.invocation.InvocationType;
import org.apache.servicecomb.swagger.invocation.arguments.ArgumentMapper;
import org.apache.servicecomb.swagger.invocation.arguments.ArgumentsMapperConfig;
import org.apache.servicecomb.swagger.invocation.arguments.ArgumentsMapperFactory;
import org.apache.servicecomb.swagger.invocation.arguments.ContextArgumentMapperFactory;
import org.apache.servicecomb.swagger.invocation.arguments.FieldInfo;
import org.apache.servicecomb.swagger.invocation.arguments.consumer.ConsumerArgumentSame;
import org.apache.servicecomb.swagger.invocation.arguments.consumer.ConsumerArgumentToBodyField;
import org.apache.servicecomb.swagger.invocation.arguments.consumer.ConsumerArgumentsMapper;
import org.apache.servicecomb.swagger.invocation.converter.Converter;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ConsumerArgumentsMapperFactory
extends ArgumentsMapperFactory {
    public ConsumerArgumentsMapperFactory() {
        this.type = InvocationType.CONSUMER;
    }

    @Inject
    @Qualifier(value="consumer")
    public void setFactoryList(List<ContextArgumentMapperFactory> factoryList) {
        this.createFactoryMap(factoryList);
    }

    @Override
    protected <T> T createArgumentsMapper(ArgumentsMapperConfig config) {
        return (T)new ConsumerArgumentsMapper(config.getArgumentMapperList(), config.getSwaggerMethod().getParameterCount());
    }

    @Override
    protected ArgumentMapper createArgumentMapperWithConverter(int swaggerIdx, int consumerIdx, Converter converter) {
        return new ConsumerArgumentSame(consumerIdx, swaggerIdx, converter);
    }

    @Override
    protected ArgumentMapper createBodyFieldArgMapper(ArgumentsMapperConfig config, Map<Integer, FieldInfo> fieldMap) {
        Class<?> swaggerParamType = config.getSwaggerMethod().getParameterTypes()[0];
        return new ConsumerArgumentToBodyField(swaggerParamType, fieldMap);
    }
}

