/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.invocation.arguments.producer;

import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.servicecomb.swagger.invocation.InvocationType;
import org.apache.servicecomb.swagger.invocation.arguments.ArgumentMapper;
import org.apache.servicecomb.swagger.invocation.arguments.ArgumentsMapperConfig;
import org.apache.servicecomb.swagger.invocation.arguments.ArgumentsMapperFactory;
import org.apache.servicecomb.swagger.invocation.arguments.ContextArgumentMapperFactory;
import org.apache.servicecomb.swagger.invocation.arguments.FieldInfo;
import org.apache.servicecomb.swagger.invocation.arguments.producer.ProducerArgumentSame;
import org.apache.servicecomb.swagger.invocation.arguments.producer.ProducerArgumentsMapper;
import org.apache.servicecomb.swagger.invocation.arguments.producer.SwaggerArgumentToProducerBodyField;
import org.apache.servicecomb.swagger.invocation.converter.Converter;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ProducerArgumentsMapperFactory
extends ArgumentsMapperFactory {
    public ProducerArgumentsMapperFactory() {
        this.type = InvocationType.PRODUCER;
    }

    @Inject
    @Qualifier(value="producer")
    public void setFactoryList(List<ContextArgumentMapperFactory> factoryList) {
        this.createFactoryMap(factoryList);
    }

    @Override
    protected <T> T createArgumentsMapper(ArgumentsMapperConfig config) {
        return (T)new ProducerArgumentsMapper(config.getArgumentMapperList(), config.getProviderMethod().getParameterCount());
    }

    @Override
    protected ArgumentMapper createArgumentMapperWithConverter(int swaggerIdx, int producerIdx, Converter converter) {
        return new ProducerArgumentSame(swaggerIdx, producerIdx, converter);
    }

    @Override
    protected ArgumentMapper createBodyFieldArgMapper(ArgumentsMapperConfig config, Map<Integer, FieldInfo> fieldMap) {
        return new SwaggerArgumentToProducerBodyField(fieldMap);
    }
}

