/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.invocation.exception;

import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.SwaggerInvocation;
import org.apache.servicecomb.swagger.invocation.exception.ExceptionToResponseConverter;

public class ExceptionToResponseConverters {
    private Map<Class<?>, ExceptionToResponseConverter<Throwable>> exceptionToResponseConverters = new HashMap();
    private ExceptionToResponseConverter<Throwable> defaultConverter;

    public ExceptionToResponseConverters() {
        SPIServiceUtils.getAllService(ExceptionToResponseConverter.class).forEach(converter -> {
            if (converter.getExceptionClass() == null) {
                this.defaultConverter = converter;
                return;
            }
            this.exceptionToResponseConverters.put(converter.getExceptionClass(), (ExceptionToResponseConverter<Throwable>)converter);
        });
    }

    public Response convertExceptionToResponse(SwaggerInvocation swaggerInvocation, Throwable e) {
        ExceptionToResponseConverter<Throwable> converter = this.exceptionToResponseConverters.getOrDefault(e.getClass(), this.defaultConverter);
        return converter.convert(swaggerInvocation, e);
    }
}

