/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.invocation.response;

import java.lang.reflect.Type;
import java.util.List;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.swagger.invocation.converter.ConverterMgr;
import org.apache.servicecomb.swagger.invocation.response.ResponseMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseMapperFactorys<MAPPER> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResponseMapperFactorys.class);
    private List<ResponseMapperFactory<MAPPER>> factorys;

    public ResponseMapperFactorys(Class<? extends ResponseMapperFactory<MAPPER>> factoryCls, ConverterMgr converterMgr) {
        this(factoryCls);
        this.setConverterMgr(converterMgr);
    }

    public ResponseMapperFactorys(Class<? extends ResponseMapperFactory<MAPPER>> factoryCls) {
        this.factorys = SPIServiceUtils.getSortedService(factoryCls);
        this.factorys.forEach(factory -> LOGGER.info("found factory {} of {}:", (Object)factory.getClass().getName(), (Object)factoryCls.getName()));
    }

    public void setConverterMgr(ConverterMgr converterMgr) {
        this.factorys.forEach(factory -> factory.setConverterMgr(converterMgr));
    }

    public MAPPER createResponseMapper(Type swaggerType, Type providerType) {
        for (ResponseMapperFactory<MAPPER> factory : this.factorys) {
            if (!factory.isMatch(swaggerType, providerType)) continue;
            return factory.createResponseMapper(this, swaggerType, providerType);
        }
        throw new IllegalStateException(String.format("can not find response mapper for %s and %s, this should never happened.", swaggerType.getTypeName(), providerType.getTypeName()));
    }
}

