/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.shadowed.org.tukaani.xz.simple;

import org.graalvm.shadowed.org.tukaani.xz.simple.SimpleFilter;

public final class PowerPC
implements SimpleFilter {
    private final boolean isEncoder;
    private int pos;

    public PowerPC(boolean isEncoder, int startPos) {
        this.isEncoder = isEncoder;
        this.pos = startPos;
    }

    @Override
    public int code(byte[] buf, int off, int len) {
        int i;
        int end = off + len - 4;
        for (i = off; i <= end; i += 4) {
            if ((buf[i] & 0xFC) != 72 || (buf[i + 3] & 3) != 1) continue;
            int src = (buf[i] & 3) << 24 | (buf[i + 1] & 0xFF) << 16 | (buf[i + 2] & 0xFF) << 8 | buf[i + 3] & 0xFC;
            int dest = this.isEncoder ? src + (this.pos + i - off) : src - (this.pos + i - off);
            buf[i] = (byte)(0x48 | dest >>> 24 & 3);
            buf[i + 1] = (byte)(dest >>> 16);
            buf[i + 2] = (byte)(dest >>> 8);
            buf[i + 3] = (byte)(buf[i + 3] & 3 | dest);
        }
        this.pos += (i -= off);
        return i;
    }
}

