/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.spring.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mybatis.spring.mapper.MapperScannerConfigurer;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MapperScannerBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String ATTRIBUTE_BASE_PACKAGE = "base-package";
    private static final String ATTRIBUTE_ANNOTATION = "annotation";
    private static final String ATTRIBUTE_MARKER_INTERFACE = "marker-interface";
    private static final String ATTRIBUTE_NAME_GENERATOR = "name-generator";
    private static final String ATTRIBUTE_TEMPLATE_REF = "template-ref";
    private static final String ATTRIBUTE_FACTORY_REF = "factory-ref";
    private static final String ATTRIBUTE_MAPPER_FACTORY_BEAN_CLASS = "mapper-factory-bean-class";
    private static final String ATTRIBUTE_LAZY_INITIALIZATION = "lazy-initialization";
    private static final String ATTRIBUTE_DEFAULT_SCOPE = "default-scope";
    private static final String ATTRIBUTE_PROCESS_PROPERTY_PLACEHOLDERS = "process-property-placeholders";
    private static final String ATTRIBUTE_EXCLUDE_FILTER = "exclude-filter";

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(MapperScannerConfigurer.class);
        ClassLoader classLoader = ClassUtils.getDefaultClassLoader();
        String processPropertyPlaceHolders = element.getAttribute(ATTRIBUTE_PROCESS_PROPERTY_PLACEHOLDERS);
        builder.addPropertyValue("processPropertyPlaceHolders", (Object)(!StringUtils.hasText((String)processPropertyPlaceHolders) || Boolean.parseBoolean(processPropertyPlaceHolders) ? 1 : 0));
        try {
            List<Map<String, String>> rawExcludeFilters;
            String mapperFactoryBeanClassName;
            String nameGeneratorClassName;
            String markerInterfaceClassName;
            String annotationClassName = element.getAttribute(ATTRIBUTE_ANNOTATION);
            if (StringUtils.hasText((String)annotationClassName)) {
                Class<?> annotationClass = classLoader.loadClass(annotationClassName);
                builder.addPropertyValue("annotationClass", annotationClass);
            }
            if (StringUtils.hasText((String)(markerInterfaceClassName = element.getAttribute(ATTRIBUTE_MARKER_INTERFACE)))) {
                Class<?> markerInterface = classLoader.loadClass(markerInterfaceClassName);
                builder.addPropertyValue("markerInterface", markerInterface);
            }
            if (StringUtils.hasText((String)(nameGeneratorClassName = element.getAttribute(ATTRIBUTE_NAME_GENERATOR)))) {
                Class<?> nameGeneratorClass = classLoader.loadClass(nameGeneratorClassName);
                BeanNameGenerator nameGenerator = (BeanNameGenerator)BeanUtils.instantiateClass(nameGeneratorClass, BeanNameGenerator.class);
                builder.addPropertyValue("nameGenerator", (Object)nameGenerator);
            }
            if (StringUtils.hasText((String)(mapperFactoryBeanClassName = element.getAttribute(ATTRIBUTE_MAPPER_FACTORY_BEAN_CLASS)))) {
                Class<?> mapperFactoryBeanClass = classLoader.loadClass(mapperFactoryBeanClassName);
                builder.addPropertyValue("mapperFactoryBeanClass", mapperFactoryBeanClass);
            }
            if (!(rawExcludeFilters = this.parseScanTypeFilters(element, parserContext)).isEmpty()) {
                builder.addPropertyValue("rawExcludeFilters", rawExcludeFilters);
            }
        }
        catch (Exception ex) {
            XmlReaderContext readerContext = parserContext.getReaderContext();
            readerContext.error(ex.getMessage(), readerContext.extractSource((Object)element), ex.getCause());
        }
        builder.addPropertyValue("sqlSessionTemplateBeanName", (Object)element.getAttribute(ATTRIBUTE_TEMPLATE_REF));
        builder.addPropertyValue("sqlSessionFactoryBeanName", (Object)element.getAttribute(ATTRIBUTE_FACTORY_REF));
        builder.addPropertyValue("lazyInitialization", (Object)element.getAttribute(ATTRIBUTE_LAZY_INITIALIZATION));
        builder.addPropertyValue("defaultScope", (Object)element.getAttribute(ATTRIBUTE_DEFAULT_SCOPE));
        builder.addPropertyValue("basePackage", (Object)element.getAttribute(ATTRIBUTE_BASE_PACKAGE));
        builder.setRole(2);
        return builder.getBeanDefinition();
    }

    private List<Map<String, String>> parseScanTypeFilters(Element element, ParserContext parserContext) {
        ArrayList<Map<String, String>> typeFilters = new ArrayList<Map<String, String>>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String localName;
            Node node = nodeList.item(i);
            if (1 != node.getNodeType() || !ATTRIBUTE_EXCLUDE_FILTER.equals(localName = parserContext.getDelegate().getLocalName(node))) continue;
            HashMap<String, String> filter = new HashMap<String, String>(16);
            filter.put("type", ((Element)node).getAttribute("type"));
            filter.put("expression", ((Element)node).getAttribute("expression"));
            typeFilters.add(filter);
        }
        return typeFilters;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }
}

