/*
 * $Id: DomEx.java,v 1.2 1999/04/04 18:48:58 db Exp $
 * 
 * Copyright (c) 1998-1999 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 */

package com.sun.xml.tree;

import java.util.Locale;

import org.w3c.dom.DOMException;


/**
 * Concrete class for DOM exceptions, associating standard messages
 * with DOM error codes.
 *
 * @author David Brownell
 * @version $Revision: 1.2 $
 */
class DomEx extends DOMException
{
    static String messageString (Locale locale, int code)
    {
	switch (code) {
	  case INDEX_SIZE_ERR:
	    return XmlDocument.catalog.getMessage (locale, "D-000");
	  case DOMSTRING_SIZE_ERR:
	    return XmlDocument.catalog.getMessage (locale, "D-001");
	  case HIERARCHY_REQUEST_ERR:
	    return XmlDocument.catalog.getMessage (locale, "D-002");
	  case WRONG_DOCUMENT_ERR:
	    return XmlDocument.catalog.getMessage (locale, "D-003");
	  case INVALID_CHARACTER_ERR:
	    return XmlDocument.catalog.getMessage (locale, "D-004");
	  case NO_DATA_ALLOWED_ERR:
	    return XmlDocument.catalog.getMessage (locale, "D-005");
	  case NO_MODIFICATION_ALLOWED_ERR:
	    return XmlDocument.catalog.getMessage (locale, "D-006");
	  case NOT_FOUND_ERR:
	    return XmlDocument.catalog.getMessage (locale, "D-007");
	  case NOT_SUPPORTED_ERR:
	    return XmlDocument.catalog.getMessage (locale, "D-008");
	  case INUSE_ATTRIBUTE_ERR:
	    return XmlDocument.catalog.getMessage (locale, "D-009");
	  default:
	    return XmlDocument.catalog.getMessage (locale, "D-010");
	}
    }

    /**
     * Creates a DOM exception which provides a standard message
     * corresponding to the given error code, using the default
     * locale for the message.
     */
    public DomEx (short code)
    {
	super (code, messageString (Locale.getDefault (), code));
    }

    /**
     * Creates a DOM exception which provides a standard message
     * corresponding to the given error code and using the specified
     * locale for the message.
     */
    public DomEx (Locale locale, short code)
    {
	super (code, messageString (locale, code));
    }
}
