// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom.html;

import org.w3c.dom.*;

/**

  <P>The 
    <code>FORM</code> element encompasses behavior similar to a collection and an element. It provides direct access to the contained input elements as well as the attributes of the form element. See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/forms.html#edef-FORM">FORM element definition</A>
 in HTML 4.0.
  
</P>

<HR>

<!-- ======== PROPERTY SUMMARY ======== -->

<A NAME="property_summary"><!-- --></A>
<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>
<TR BGCOLOR=#CCCCFF ID=TableHeadingColor>
<TD COLSPAN=3><FONT SIZE=+2><B>Property Summary</B>
</FONT></TD></TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-elements><CODE>&nbsp;elements</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getElements()'>getElements</a>
</TD>
<TD>
  <P>Returns a collection of all control elements in the form. 
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-length><CODE>&nbsp;length</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getLength()'>getLength</a>
</TD>
<TD>
  <P>The number of form controls in the form.
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-name><CODE>&nbsp;name</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getName()'>getName</a>
<a href='#setName(java.lang.String)'>setName</a>
</TD>
<TD>
  <P>Names the form. 
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-acceptCharset><CODE>&nbsp;acceptCharset</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getAcceptCharset()'>getAcceptCharset</a>
<a href='#setAcceptCharset(java.lang.String)'>setAcceptCharset</a>
</TD>
<TD>
  <P>List of character sets supported by the server. See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-accept-charset">accept-charset attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-action><CODE>&nbsp;action</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getAction()'>getAction</a>
<a href='#setAction(java.lang.String)'>setAction</a>
</TD>
<TD>
  <P>Server-side form handler. See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-action">action attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-enctype><CODE>&nbsp;enctype</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getEnctype()'>getEnctype</a>
<a href='#setEnctype(java.lang.String)'>setEnctype</a>
</TD>
<TD>
  <P>The content type of the submitted form, generally "application/x-www-form-urlencoded". See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-enctype">enctype attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-method><CODE>&nbsp;method</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getMethod()'>getMethod</a>
<a href='#setMethod(java.lang.String)'>setMethod</a>
</TD>
<TD>
  <P>HTTP method used to submit form. See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-method">method attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-target><CODE>&nbsp;target</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getTarget()'>getTarget</a>
<a href='#setTarget(java.lang.String)'>setTarget</a>
</TD>
<TD>
  <P>Frame to render the resource in. See the 
    <A  href="http://www.w3.org/TR/REC-html40/present/frames.html#adef-target">target attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
</TABLE>
&nbsp;
*/
public interface HTMLFormElement
extends HTMLElement
{
	/**
	 * Returns the value of the <code><a href=#att-elements>elements</a></code> property.
	*/
	HTMLCollection getElements ();


	/**
	 * Returns the value of the <code><a href=#att-length>length</a></code> property.
	*/
	int getLength ();


	/** Assigns the value of the <code><a href=#att-name>name</a></code> property.
	 */
	void setName (String name);

	/**
	 * Returns the value of the <code><a href=#att-name>name</a></code> property.
	*/
	String getName ();


	/** Assigns the value of the <code><a href=#att-acceptCharset>acceptCharset</a></code> property.
	 */
	void setAcceptCharset (String acceptCharset);

	/**
	 * Returns the value of the <code><a href=#att-acceptCharset>acceptCharset</a></code> property.
	*/
	String getAcceptCharset ();


	/** Assigns the value of the <code><a href=#att-action>action</a></code> property.
	 */
	void setAction (String action);

	/**
	 * Returns the value of the <code><a href=#att-action>action</a></code> property.
	*/
	String getAction ();


	/** Assigns the value of the <code><a href=#att-enctype>enctype</a></code> property.
	 */
	void setEnctype (String enctype);

	/**
	 * Returns the value of the <code><a href=#att-enctype>enctype</a></code> property.
	*/
	String getEnctype ();


	/** Assigns the value of the <code><a href=#att-method>method</a></code> property.
	 */
	void setMethod (String method);

	/**
	 * Returns the value of the <code><a href=#att-method>method</a></code> property.
	*/
	String getMethod ();


	/** Assigns the value of the <code><a href=#att-target>target</a></code> property.
	 */
	void setTarget (String target);

	/**
	 * Returns the value of the <code><a href=#att-target>target</a></code> property.
	*/
	String getTarget ();


/**

  <P>Submits the form. It performs the same action as a submit button.
</P>

*/
void submit ();

/**

  <P>Restores a form element's default values. It performs the same action as a reset button.
</P>

*/
void reset ();

}
