// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom.html;

import org.w3c.dom.*;

/**

  <P>The object used to represent the 
    <code>TH</code> and 
    <code>TD</code>
elements. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/tables.html#edef-TD">TD element definition</A>
 in HTML 4.0.
  
</P>

<HR>

<!-- ======== PROPERTY SUMMARY ======== -->

<A NAME="property_summary"><!-- --></A>
<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>
<TR BGCOLOR=#CCCCFF ID=TableHeadingColor>
<TD COLSPAN=3><FONT SIZE=+2><B>Property Summary</B>
</FONT></TD></TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-cellIndex><CODE>&nbsp;cellIndex</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getCellIndex()'>getCellIndex</a>
<a href='#setCellIndex(java.lang.String)'>setCellIndex</a>
</TD>
<TD>
  <P>The index of this cell in the row. 
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-abbr><CODE>&nbsp;abbr</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getAbbr()'>getAbbr</a>
<a href='#setAbbr(java.lang.String)'>setAbbr</a>
</TD>
<TD>
  <P>Abbreviation for header cells. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-abbr">abbr attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-align><CODE>&nbsp;align</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getAlign()'>getAlign</a>
<a href='#setAlign(java.lang.String)'>setAlign</a>
</TD>
<TD>
  <P>Horizontal alignment of data in cell. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-align-TD">align attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-axis><CODE>&nbsp;axis</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getAxis()'>getAxis</a>
<a href='#setAxis(java.lang.String)'>setAxis</a>
</TD>
<TD>
  <P>Names group of related headers. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-axis">axis attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-bgColor><CODE>&nbsp;bgColor</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getBgColor()'>getBgColor</a>
<a href='#setBgColor(java.lang.String)'>setBgColor</a>
</TD>
<TD>
  <P>Cell background color. See the 
    <A  href="http://www.w3.org/TR/REC-html40/present/graphics.html#adef-bgcolor">bgcolor attribute definition</A>
 in HTML 4.0. This attribute is deprecated in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-ch><CODE>&nbsp;ch</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getCh()'>getCh</a>
<a href='#setCh(java.lang.String)'>setCh</a>
</TD>
<TD>
  <P>Alignment character for cells in a column. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-char">char attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-chOff><CODE>&nbsp;chOff</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getChOff()'>getChOff</a>
<a href='#setChOff(java.lang.String)'>setChOff</a>
</TD>
<TD>
  <P>Offset of alignment character. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-charoff">charoff attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-colSpan><CODE>&nbsp;colSpan</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getColSpan()'>getColSpan</a>
<a href='#setColSpan(java.lang.String)'>setColSpan</a>
</TD>
<TD>
  <P>Number of columns spanned by cell. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-colspan">colspan attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-headers><CODE>&nbsp;headers</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getHeaders()'>getHeaders</a>
<a href='#setHeaders(java.lang.String)'>setHeaders</a>
</TD>
<TD>
  <P>List of 
    <code>id</code> attribute values for header cells. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-headers">headers attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-height><CODE>&nbsp;height</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getHeight()'>getHeight</a>
<a href='#setHeight(java.lang.String)'>setHeight</a>
</TD>
<TD>
  <P>Cell height. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-height-TH">height attribute definition</A>
 in HTML 4.0. This attribute is deprecated in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-noWrap><CODE>&nbsp;noWrap</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getNoWrap()'>getNoWrap</a>
<a href='#setNoWrap(java.lang.String)'>setNoWrap</a>
</TD>
<TD>
  <P>Suppress word wrapping. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-nowrap">nowrap attribute definition</A>
 in HTML 4.0. This attribute is deprecated in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-rowSpan><CODE>&nbsp;rowSpan</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getRowSpan()'>getRowSpan</a>
<a href='#setRowSpan(java.lang.String)'>setRowSpan</a>
</TD>
<TD>
  <P>Number of rows spanned by cell. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-rowspan">rowspan attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-scope><CODE>&nbsp;scope</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getScope()'>getScope</a>
<a href='#setScope(java.lang.String)'>setScope</a>
</TD>
<TD>
  <P>Scope covered by header cells. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-scope">scope attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-vAlign><CODE>&nbsp;vAlign</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getVAlign()'>getVAlign</a>
<a href='#setVAlign(java.lang.String)'>setVAlign</a>
</TD>
<TD>
  <P>Vertical alignment of data in cell. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-valign">valign attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-width><CODE>&nbsp;width</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getWidth()'>getWidth</a>
<a href='#setWidth(java.lang.String)'>setWidth</a>
</TD>
<TD>
  <P>Cell width. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-width-TH">width attribute definition</A>
 in HTML 4.0. This attribute is deprecated in HTML 4.0.
  
</P>
</TD>
</TR>
</TABLE>
&nbsp;
*/
public interface HTMLTableCellElement
extends HTMLElement
{
	/** Assigns the value of the <code><a href=#att-cellIndex>cellIndex</a></code> property.
	 */
	void setCellIndex (int cellIndex);

	/**
	 * Returns the value of the <code><a href=#att-cellIndex>cellIndex</a></code> property.
	*/
	int getCellIndex ();


	/** Assigns the value of the <code><a href=#att-abbr>abbr</a></code> property.
	 */
	void setAbbr (String abbr);

	/**
	 * Returns the value of the <code><a href=#att-abbr>abbr</a></code> property.
	*/
	String getAbbr ();


	/** Assigns the value of the <code><a href=#att-align>align</a></code> property.
	 */
	void setAlign (String align);

	/**
	 * Returns the value of the <code><a href=#att-align>align</a></code> property.
	*/
	String getAlign ();


	/** Assigns the value of the <code><a href=#att-axis>axis</a></code> property.
	 */
	void setAxis (String axis);

	/**
	 * Returns the value of the <code><a href=#att-axis>axis</a></code> property.
	*/
	String getAxis ();


	/** Assigns the value of the <code><a href=#att-bgColor>bgColor</a></code> property.
	 */
	void setBgColor (String bgColor);

	/**
	 * Returns the value of the <code><a href=#att-bgColor>bgColor</a></code> property.
	*/
	String getBgColor ();


	/** Assigns the value of the <code><a href=#att-ch>ch</a></code> property.
	 */
	void setCh (String ch);

	/**
	 * Returns the value of the <code><a href=#att-ch>ch</a></code> property.
	*/
	String getCh ();


	/** Assigns the value of the <code><a href=#att-chOff>chOff</a></code> property.
	 */
	void setChOff (String chOff);

	/**
	 * Returns the value of the <code><a href=#att-chOff>chOff</a></code> property.
	*/
	String getChOff ();


	/** Assigns the value of the <code><a href=#att-colSpan>colSpan</a></code> property.
	 */
	void setColSpan (int colSpan);

	/**
	 * Returns the value of the <code><a href=#att-colSpan>colSpan</a></code> property.
	*/
	int getColSpan ();


	/** Assigns the value of the <code><a href=#att-headers>headers</a></code> property.
	 */
	void setHeaders (String headers);

	/**
	 * Returns the value of the <code><a href=#att-headers>headers</a></code> property.
	*/
	String getHeaders ();


	/** Assigns the value of the <code><a href=#att-height>height</a></code> property.
	 */
	void setHeight (String height);

	/**
	 * Returns the value of the <code><a href=#att-height>height</a></code> property.
	*/
	String getHeight ();


	/** Assigns the value of the <code><a href=#att-noWrap>noWrap</a></code> property.
	 */
	void setNoWrap (boolean noWrap);

	/**
	 * Returns the value of the <code><a href=#att-noWrap>noWrap</a></code> property.
	*/
	boolean getNoWrap ();


	/** Assigns the value of the <code><a href=#att-rowSpan>rowSpan</a></code> property.
	 */
	void setRowSpan (int rowSpan);

	/**
	 * Returns the value of the <code><a href=#att-rowSpan>rowSpan</a></code> property.
	*/
	int getRowSpan ();


	/** Assigns the value of the <code><a href=#att-scope>scope</a></code> property.
	 */
	void setScope (String scope);

	/**
	 * Returns the value of the <code><a href=#att-scope>scope</a></code> property.
	*/
	String getScope ();


	/** Assigns the value of the <code><a href=#att-vAlign>vAlign</a></code> property.
	 */
	void setVAlign (String vAlign);

	/**
	 * Returns the value of the <code><a href=#att-vAlign>vAlign</a></code> property.
	*/
	String getVAlign ();


	/** Assigns the value of the <code><a href=#att-width>width</a></code> property.
	 */
	void setWidth (String width);

	/**
	 * Returns the value of the <code><a href=#att-width>width</a></code> property.
	*/
	String getWidth ();


}
