/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.aliyun.auth.provider;

import com.alibaba.nacos.api.utils.StringUtils;
import com.alibaba.nacos.client.aliyun.auth.ExtensionAuthPropertyKey;
import com.alibaba.nacos.client.aliyun.auth.provider.AbstractCredentialClientProvider;
import com.aliyun.credentials.models.Config;
import java.util.Properties;

public class OidcRoleArnCredentialsProvider
extends AbstractCredentialClientProvider {
    @Override
    public boolean matchProvider(Properties properties) {
        String arnRole = this.getNacosProperties(properties, ExtensionAuthPropertyKey.ROLE_ARN);
        String roleSessionName = this.getNacosProperties(properties, ExtensionAuthPropertyKey.ROLE_SESSION_NAME);
        String oidcProviderArn = this.getNacosProperties(properties, ExtensionAuthPropertyKey.OIDC_PROVIDER_ARN);
        return !StringUtils.isEmpty((CharSequence)arnRole) && !StringUtils.isEmpty((CharSequence)roleSessionName) && !StringUtils.isEmpty((CharSequence)oidcProviderArn);
    }

    @Override
    protected Config generateCredentialsConfig(Properties properties) {
        Config config = new Config();
        config.setType("oidc_role_arn");
        config.setRoleArn(this.getNacosProperties(properties, ExtensionAuthPropertyKey.ROLE_ARN));
        config.setRoleSessionName(this.getNacosProperties(properties, ExtensionAuthPropertyKey.ROLE_SESSION_NAME));
        config.setOidcProviderArn(this.getNacosProperties(properties, ExtensionAuthPropertyKey.OIDC_PROVIDER_ARN));
        config.setOidcTokenFilePath(this.getNacosProperties(properties, ExtensionAuthPropertyKey.OIDC_TOKEN_FILE_PATH));
        return this.injectCommonBasicConfig(properties, config);
    }
}

