/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.event.handler;

import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.data.event.EventCenter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractEventHandler<T>
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractEventHandler.class);
    @Autowired
    private EventCenter eventCenter;

    public void afterPropertiesSet() throws Exception {
        this.eventCenter.register(this);
    }

    public void handle(T event) {
        try {
            this.doHandle(event);
        }
        catch (Exception e) {
            LOGGER.error("[{}] handle event error", (Object)this.getClass().getSimpleName(), (Object)e);
        }
    }

    public abstract Class interest();

    public abstract void doHandle(T var1);
}

