/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.remoting.handler;

import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;

public abstract class AbstractClientHandler<T>
implements ChannelHandler<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractClientHandler.class);

    public void connected(Channel channel) {
        if (channel != null && channel.isConnected()) {
            LOGGER.info(this.getConnectNodeType() + " node connected,remote address:" + channel.getRemoteAddress() + " localAddress:" + channel.getLocalAddress());
        }
    }

    public void disconnected(Channel channel) {
        if (channel != null && !channel.isConnected()) {
            LOGGER.info(this.getConnectNodeType() + " node disconnected,remote address:" + channel.getRemoteAddress() + " localAddress:" + channel.getLocalAddress());
        }
    }

    protected abstract Node.NodeType getConnectNodeType();

    public void caught(Channel channel, T message, Throwable exception) {
    }

    public void received(Channel channel, T message) {
    }

    public Object reply(Channel channel, T request) {
        try {
            this.logRequest(request);
            this.checkParam(request);
            return this.doHandle(channel, request);
        }
        catch (Exception e) {
            LOGGER.error("[{}] handle request failed", (Object)this.getClassName(), (Object)e);
            return this.buildFailedResponse(e.getMessage());
        }
    }

    public abstract void checkParam(T var1) throws RuntimeException;

    public abstract Object doHandle(Channel var1, T var2);

    public abstract Object buildFailedResponse(String var1);

    protected void logRequest(T request) {
        this.log(request.toString());
    }

    protected void log(String log) {
        LOGGER.info("[" + this.getClassName() + "] " + log);
    }

    public Class interest() {
        return null;
    }

    private String getClassName() {
        return this.getClass().getSimpleName();
    }
}

