/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.auth;

import com.alicloud.openservices.tablestore.core.auth.AuthUtils;
import com.alicloud.openservices.tablestore.core.auth.CredentialsProvider;
import com.alicloud.openservices.tablestore.core.auth.DefaultCredentials;
import com.alicloud.openservices.tablestore.core.auth.InvalidCredentialsException;
import com.alicloud.openservices.tablestore.core.auth.ServiceCredentials;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.core.utils.StringUtils;

public class EnvironmentVariableCredentialsProvider
implements CredentialsProvider {
    @Override
    public void setCredentials(ServiceCredentials creds) {
    }

    @Override
    public ServiceCredentials getCredentials() {
        String accessKeyId = StringUtils.trim(System.getenv("TABLESTORE_ACCESS_KEY_ID"));
        String secretAccessKey = StringUtils.trim(System.getenv("TABLESTORE_ACCESS_KEY_SECRET"));
        String sessionToken = StringUtils.trim(System.getenv("TABLESTORE_SESSION_TOKEN"));
        if (accessKeyId == null || accessKeyId.equals("")) {
            throw new InvalidCredentialsException("Access key id should not be null or empty.");
        }
        if (secretAccessKey == null || secretAccessKey.equals("")) {
            throw new InvalidCredentialsException("Secret access key should not be null or empty.");
        }
        Preconditions.checkArgument(AuthUtils.checkAccessKeyIdFormat(accessKeyId), "The access key id is invalid: " + accessKeyId);
        return new DefaultCredentials(accessKeyId, secretAccessKey, sessionToken);
    }
}

