/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.search.query;

import com.alicloud.openservices.tablestore.core.protocol.SearchQueryBuilder;
import com.alicloud.openservices.tablestore.model.search.query.Query;
import com.alicloud.openservices.tablestore.model.search.query.QueryBuilder;
import com.alicloud.openservices.tablestore.model.search.query.QueryOperator;
import com.alicloud.openservices.tablestore.model.search.query.QueryType;
import com.aliyun.ots.thirdparty.com.google.protobuf.ByteString;

public class MatchQuery
implements Query {
    private final QueryType queryType = QueryType.QueryType_MatchQuery;
    private String fieldName;
    private String text;
    private float weight = 1.0f;
    private Integer minimumShouldMatch;
    private QueryOperator operator;

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float weight) {
        this.weight = weight;
    }

    public QueryOperator getOperator() {
        return this.operator;
    }

    public void setOperator(QueryOperator operator) {
        this.operator = operator;
    }

    public Integer getMinimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    public void setMinimumShouldMatch(Integer minimumShouldMatch) {
        this.minimumShouldMatch = minimumShouldMatch;
    }

    @Override
    public QueryType getQueryType() {
        return this.queryType;
    }

    @Override
    public ByteString serialize() {
        return SearchQueryBuilder.buildMatchQuery(this).toByteString();
    }

    protected static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder
    implements QueryBuilder {
        private String fieldName;
        private String text;
        private Integer minimumShouldMatch;
        private QueryOperator operator;
        private float weight = 1.0f;

        public Builder weight(float weight) {
            this.weight = weight;
            return this;
        }

        private Builder() {
        }

        public Builder field(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder minimumShouldMatch(int minimumShouldMatch) {
            this.minimumShouldMatch = minimumShouldMatch;
            return this;
        }

        public Builder operator(QueryOperator queryOperator) {
            this.operator = queryOperator;
            return this;
        }

        @Override
        public MatchQuery build() {
            MatchQuery matchQuery = new MatchQuery();
            matchQuery.setFieldName(this.fieldName);
            matchQuery.setMinimumShouldMatch(this.minimumShouldMatch);
            matchQuery.setText(this.text);
            matchQuery.setWeight(this.weight);
            matchQuery.setOperator(this.operator);
            return matchQuery;
        }
    }
}

