/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timestream.model.query;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.model.search.sort.FieldSort;
import com.alicloud.openservices.tablestore.model.search.sort.GeoDistanceSort;
import com.alicloud.openservices.tablestore.model.search.sort.Sort;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Sorter {
    private List<Sort.Sorter> sorterList = new ArrayList<Sort.Sorter>();

    private Sorter() {
    }

    private Sorter addSubSorter(Sort.Sorter sorter) {
        this.sorterList.add(sorter);
        return this;
    }

    public List<Sort.Sorter> getSorter() {
        return this.sorterList;
    }

    public static final class Builder {
        private Sorter sorter = null;

        private Builder() {
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder sortByName(SortOrder sortOrder) {
            return this.sortByAttributes("n", sortOrder);
        }

        public Builder sortByAttributes(String key, SortOrder sortOrder) {
            if (this.sorter == null) {
                this.sorter = new Sorter();
            }
            this.sorter.addSubSorter(new FieldSort(key, sortOrder.toSearchSortOrder()));
            return this;
        }

        public Builder sortByAttributesInGeo(String key, String center, SortOrder sortOrder) {
            if (this.sorter == null) {
                this.sorter = new Sorter();
            }
            GeoDistanceSort tmpSort = new GeoDistanceSort(key, Arrays.asList(center));
            tmpSort.setOrder(sortOrder.toSearchSortOrder());
            this.sorter.addSubSorter(tmpSort);
            return this;
        }

        public Sorter build() {
            if (this.sorter == null) {
                throw new ClientException("");
            }
            return this.sorter;
        }
    }

    public static enum SortOrder {
        ASC,
        DESC;


        public com.alicloud.openservices.tablestore.model.search.sort.SortOrder toSearchSortOrder() {
            if (this == ASC) {
                return com.alicloud.openservices.tablestore.model.search.sort.SortOrder.ASC;
            }
            return com.alicloud.openservices.tablestore.model.search.sort.SortOrder.DESC;
        }
    }
}

