/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.ark.runtime.model.images.generation;

import com.fasterxml.jackson.annotation.JsonProperty;

public class GenerateImagesRequest {
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="prompt")
    private String prompt;
    @JsonProperty(value="image")
    private String image;
    @JsonProperty(value="response_format")
    private String responseFormat;
    @JsonProperty(value="seed")
    private Integer seed;
    @JsonProperty(value="guidance_scale")
    private Double guidanceScale;
    @JsonProperty(value="size")
    private String size;
    @JsonProperty(value="watermark")
    private Boolean watermark;
    @JsonProperty(value="optimize_prompt")
    private Boolean optimizePrompt;

    public GenerateImagesRequest() {
    }

    public GenerateImagesRequest(String model, String prompt, String image, String responseFormat, Integer seed, Double guidanceScale, String size) {
        this.model = model;
        this.prompt = prompt;
        this.image = image;
        this.responseFormat = responseFormat;
        this.seed = seed;
        this.guidanceScale = guidanceScale;
        this.size = size;
        this.watermark = false;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(String responseFormat) {
        this.responseFormat = responseFormat;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public void setSeed(Integer seed) {
        this.seed = seed;
    }

    public Double getGuidanceScale() {
        return this.guidanceScale;
    }

    public void setGuidanceScale(Double guidanceScale) {
        this.guidanceScale = guidanceScale;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public Boolean getWatermark() {
        return this.watermark;
    }

    public void setWatermark(Boolean watermark) {
        this.watermark = watermark;
    }

    public Boolean getOptimizePrompt() {
        return this.optimizePrompt;
    }

    public void setOptimizePrompt(Boolean optimizePrompt) {
        this.optimizePrompt = optimizePrompt;
    }

    public String toString() {
        return "GenerateImagesRequest{model='" + this.model + '\'' + ", prompt=" + this.prompt + ", image=" + this.image + ", responseFormat=" + this.responseFormat + ", seed=" + this.seed + ", guidanceScale=" + this.guidanceScale + ", size=" + this.size + ", watermark=" + this.watermark + ", optimizePrompt=" + this.optimizePrompt + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String model;
        private String prompt;
        private String image;
        private String responseFormat;
        private Integer seed;
        private Double guidanceScale;
        private String size;
        private Boolean watermark;
        private Boolean optimizePrompt;

        private Builder() {
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        public Builder image(String image) {
            this.image = image;
            return this;
        }

        public Builder responseFormat(String responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public Builder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public Builder guidanceScale(Double guidanceScale) {
            this.guidanceScale = guidanceScale;
            return this;
        }

        public Builder size(String size) {
            this.size = size;
            return this;
        }

        public Builder watermark(Boolean watermark) {
            this.watermark = watermark;
            return this;
        }

        public Builder optimizePrompt(Boolean optimizePrompt) {
            this.optimizePrompt = optimizePrompt;
            return this;
        }

        public GenerateImagesRequest build() {
            GenerateImagesRequest generateImagesRequest = new GenerateImagesRequest();
            generateImagesRequest.setModel(this.model);
            generateImagesRequest.setPrompt(this.prompt);
            generateImagesRequest.setImage(this.image);
            generateImagesRequest.setResponseFormat(this.responseFormat);
            generateImagesRequest.setSeed(this.seed);
            generateImagesRequest.setGuidanceScale(this.guidanceScale);
            generateImagesRequest.setSize(this.size);
            generateImagesRequest.setWatermark(this.watermark);
            generateImagesRequest.setOptimizePrompt(this.optimizePrompt);
            return generateImagesRequest;
        }
    }
}

