/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.namenode.rpc.darpc;

import com.ibm.darpc.DaRPCClientEndpoint;
import com.ibm.darpc.DaRPCClientGroup;
import com.ibm.darpc.DaRPCProtocol;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.crail.conf.CrailConfiguration;
import org.apache.crail.namenode.rpc.darpc.DaRPCConstants;
import org.apache.crail.namenode.rpc.darpc.DaRPCNameNodeConnection;
import org.apache.crail.namenode.rpc.darpc.DaRPCNameNodeProtocol;
import org.apache.crail.namenode.rpc.darpc.DaRPCNameNodeRequest;
import org.apache.crail.namenode.rpc.darpc.DaRPCNameNodeResponse;
import org.apache.crail.rpc.RpcClient;
import org.apache.crail.rpc.RpcConnection;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;

public class DaRPCNameNodeClient
implements RpcClient {
    private static final Logger LOG = CrailUtils.getLogger();
    private DaRPCNameNodeProtocol namenodeProtocol = null;
    private DaRPCClientGroup<DaRPCNameNodeRequest, DaRPCNameNodeResponse> namenodeClientGroup = null;

    public void init(CrailConfiguration conf, String[] args) throws Exception {
        DaRPCConstants.updateConstants(conf);
        DaRPCConstants.verify();
        this.namenodeProtocol = new DaRPCNameNodeProtocol();
        this.namenodeClientGroup = DaRPCClientGroup.createClientGroup((DaRPCProtocol)this.namenodeProtocol, (int)100, (int)DaRPCConstants.NAMENODE_DARPC_MAXINLINE, (int)DaRPCConstants.NAMENODE_DARPC_RECVQUEUE, (int)DaRPCConstants.NAMENODE_DARPC_SENDQUEUE);
        LOG.info("rpc group started, recvQueue " + this.namenodeClientGroup.recvQueueSize());
    }

    public void printConf(Logger logger) {
        DaRPCConstants.printConf(logger);
    }

    public RpcConnection connect(InetSocketAddress address) throws Exception {
        DaRPCClientEndpoint namenodeEndopoint = (DaRPCClientEndpoint)this.namenodeClientGroup.createEndpoint();
        namenodeEndopoint.connect((SocketAddress)address, DaRPCConstants.NAMENODE_DARPC_CONNECTTIMEOUT);
        DaRPCNameNodeConnection connection = new DaRPCNameNodeConnection((DaRPCClientEndpoint<DaRPCNameNodeRequest, DaRPCNameNodeResponse>)namenodeEndopoint);
        return connection;
    }

    public void close() {
        try {
            if (this.namenodeClientGroup != null) {
                this.namenodeClientGroup.close();
                this.namenodeClientGroup = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.info("Error while closing " + e.getMessage());
        }
    }
}

