/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.namenode.rpc.darpc;

import com.ibm.darpc.DaRPCMessage;
import java.nio.ByteBuffer;
import org.apache.crail.rpc.RpcNameNodeState;
import org.apache.crail.rpc.RpcResponseMessage;

public class DaRPCNameNodeResponse
implements DaRPCMessage,
RpcNameNodeState {
    public static final int CSIZE = 4 + Math.max(RpcResponseMessage.GetBlockRes.CSIZE, RpcResponseMessage.RenameRes.CSIZE);
    private short type;
    private short error;
    private RpcResponseMessage.VoidRes voidRes;
    private RpcResponseMessage.CreateFileRes createFileRes;
    private RpcResponseMessage.GetFileRes getFileRes;
    private RpcResponseMessage.DeleteFileRes delFileRes;
    private RpcResponseMessage.RenameRes renameRes;
    private RpcResponseMessage.GetBlockRes getBlockRes;
    private RpcResponseMessage.GetLocationRes getLocationRes;
    private RpcResponseMessage.GetDataNodeRes getDataNodeRes;
    private RpcResponseMessage.PingNameNodeRes pingNameNodeRes;

    public DaRPCNameNodeResponse() {
        this.type = 0;
        this.error = 0;
        this.voidRes = new RpcResponseMessage.VoidRes();
        this.createFileRes = new RpcResponseMessage.CreateFileRes();
        this.getFileRes = new RpcResponseMessage.GetFileRes();
        this.delFileRes = new RpcResponseMessage.DeleteFileRes();
        this.renameRes = new RpcResponseMessage.RenameRes();
        this.getBlockRes = new RpcResponseMessage.GetBlockRes();
        this.getLocationRes = new RpcResponseMessage.GetLocationRes();
        this.getDataNodeRes = new RpcResponseMessage.GetDataNodeRes();
        this.pingNameNodeRes = new RpcResponseMessage.PingNameNodeRes();
    }

    public DaRPCNameNodeResponse(RpcResponseMessage.VoidRes message) {
        this.type = message.getType();
        this.voidRes = message;
    }

    public DaRPCNameNodeResponse(RpcResponseMessage.CreateFileRes message) {
        this.type = message.getType();
        this.createFileRes = message;
    }

    public DaRPCNameNodeResponse(RpcResponseMessage.GetFileRes message) {
        this.type = message.getType();
        this.getFileRes = message;
    }

    public DaRPCNameNodeResponse(RpcResponseMessage.DeleteFileRes message) {
        this.type = message.getType();
        this.delFileRes = message;
    }

    public DaRPCNameNodeResponse(RpcResponseMessage.RenameRes message) {
        this.type = message.getType();
        this.renameRes = message;
    }

    public DaRPCNameNodeResponse(RpcResponseMessage.GetBlockRes message) {
        this.type = message.getType();
        this.getBlockRes = message;
    }

    public DaRPCNameNodeResponse(RpcResponseMessage.GetLocationRes message) {
        this.type = message.getType();
        this.getLocationRes = message;
    }

    public DaRPCNameNodeResponse(RpcResponseMessage.GetDataNodeRes message) {
        this.type = message.getType();
        this.getDataNodeRes = message;
    }

    public DaRPCNameNodeResponse(RpcResponseMessage.PingNameNodeRes message) {
        this.type = message.getType();
        this.pingNameNodeRes = message;
    }

    public void setType(short type) throws Exception {
        this.type = type;
        switch (type) {
            case 1: {
                if (this.voidRes != null) break;
                throw new Exception("Response type not set");
            }
            case 2: {
                if (this.createFileRes != null) break;
                throw new Exception("Response type not set");
            }
            case 3: {
                if (this.getFileRes != null) break;
                throw new Exception("Response type not set");
            }
            case 4: {
                if (this.delFileRes != null) break;
                throw new Exception("Response type not set");
            }
            case 5: {
                if (this.renameRes != null) break;
                throw new Exception("Response type not set");
            }
            case 6: {
                if (this.getBlockRes != null) break;
                throw new Exception("Response type not set");
            }
            case 7: {
                if (this.getLocationRes != null) break;
                throw new Exception("Response type not set");
            }
            case 10: {
                if (this.getDataNodeRes != null) break;
                throw new Exception("Response type not set");
            }
            case 9: {
                if (this.pingNameNodeRes != null) break;
                throw new Exception("Response type not set");
            }
        }
    }

    public int size() {
        return CSIZE;
    }

    public int write(ByteBuffer buffer) {
        buffer.putShort(this.type);
        buffer.putShort(this.error);
        int written = 4;
        switch (this.type) {
            case 1: {
                written += this.voidRes.write(buffer);
                break;
            }
            case 2: {
                written += this.createFileRes.write(buffer);
                break;
            }
            case 3: {
                written += this.getFileRes.write(buffer);
                break;
            }
            case 4: {
                written += this.delFileRes.write(buffer);
                break;
            }
            case 5: {
                written += this.renameRes.write(buffer);
                break;
            }
            case 6: {
                written += this.getBlockRes.write(buffer);
                break;
            }
            case 7: {
                written += this.getLocationRes.write(buffer);
                break;
            }
            case 10: {
                written += this.getDataNodeRes.write(buffer);
                break;
            }
            case 9: {
                written += this.pingNameNodeRes.write(buffer);
            }
        }
        return written;
    }

    public void update(ByteBuffer buffer) {
        this.type = buffer.getShort();
        this.error = buffer.getShort();
        switch (this.type) {
            case 1: {
                this.voidRes.update(buffer);
                this.voidRes.setError(this.error);
                break;
            }
            case 2: {
                this.createFileRes.update(buffer);
                this.createFileRes.setError(this.error);
                break;
            }
            case 3: {
                this.getFileRes.update(buffer);
                this.getFileRes.setError(this.error);
                break;
            }
            case 4: {
                this.delFileRes.update(buffer);
                this.delFileRes.setError(this.error);
                break;
            }
            case 5: {
                this.renameRes.update(buffer);
                this.renameRes.setError(this.error);
                break;
            }
            case 6: {
                this.getBlockRes.update(buffer);
                this.getBlockRes.setError(this.error);
                break;
            }
            case 7: {
                this.getLocationRes.update(buffer);
                this.getLocationRes.setError(this.error);
                break;
            }
            case 10: {
                this.getDataNodeRes.update(buffer);
                this.getDataNodeRes.setError(this.error);
                break;
            }
            case 9: {
                this.pingNameNodeRes.update(buffer);
                this.pingNameNodeRes.setError(this.error);
            }
        }
    }

    public short getType() {
        return this.type;
    }

    public short getError() {
        return this.error;
    }

    public void setError(short error) {
        this.error = error;
    }

    public RpcResponseMessage.VoidRes getVoid() {
        return this.voidRes;
    }

    public RpcResponseMessage.CreateFileRes createFile() {
        return this.createFileRes;
    }

    public RpcResponseMessage.GetFileRes getFile() {
        return this.getFileRes;
    }

    public RpcResponseMessage.DeleteFileRes delFile() {
        return this.delFileRes;
    }

    public RpcResponseMessage.RenameRes getRename() {
        return this.renameRes;
    }

    public RpcResponseMessage.GetBlockRes getBlock() {
        return this.getBlockRes;
    }

    public RpcResponseMessage.GetLocationRes getLocation() {
        return this.getLocationRes;
    }

    public RpcResponseMessage.GetDataNodeRes getDataNode() {
        return this.getDataNodeRes;
    }

    public RpcResponseMessage.PingNameNodeRes pingNameNode() {
        return this.pingNameNodeRes;
    }
}

