/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.storage.rdma;

import com.ibm.disni.verbs.IbvMr;
import com.ibm.disni.verbs.IbvPd;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.crail.CrailBuffer;

public class MrCache {
    private ConcurrentHashMap<Integer, DeviceMrCache> cache = new ConcurrentHashMap();
    private AtomicLong cacheOps;
    private AtomicLong cacheMisses = new AtomicLong(0L);

    public MrCache() {
        this.cacheOps = new AtomicLong(0L);
    }

    public DeviceMrCache getDeviceCache(IbvPd pd) throws IOException {
        DeviceMrCache deviceCache = this.cache.get(pd.getHandle());
        if (deviceCache == null) {
            deviceCache = new DeviceMrCache(pd);
            DeviceMrCache oldLine = this.cache.putIfAbsent(pd.getHandle(), deviceCache);
            if (oldLine != null) {
                deviceCache = oldLine;
            }
        }
        return deviceCache;
    }

    public void close() throws IOException {
        for (DeviceMrCache line : this.cache.values()) {
            line.close();
        }
        this.cache.clear();
    }

    public long ops() {
        return this.cacheOps.get();
    }

    public long missed() {
        return this.cacheMisses.get();
    }

    public void reset() {
        this.cacheOps.set(0L);
        this.cacheMisses.set(0L);
    }

    public static class DeviceMrCache {
        private IbvPd pd;
        private ConcurrentHashMap<Long, IbvMr> device;

        public DeviceMrCache(IbvPd pd) {
            this.pd = pd;
            this.device = new ConcurrentHashMap();
        }

        public IbvMr get(CrailBuffer buffer) throws IOException {
            IbvMr mr = this.device.get(buffer.address());
            return mr;
        }

        public void put(IbvMr mr) throws IOException {
            this.device.put(mr.getAddr(), mr);
        }

        public void close() throws IOException {
            for (IbvMr mr : this.device.values()) {
                mr.deregMr().free();
            }
            this.device.clear();
        }

        public IbvPd getPd() {
            return this.pd;
        }
    }
}

