/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.storage.rdma;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.crail.conf.CrailConfiguration;
import org.apache.crail.conf.CrailConstants;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;

public class RdmaConstants {
    private static final Logger LOG = CrailUtils.getLogger();
    public static final String STORAGE_RDMA_INTERFACE_KEY = "crail.storage.rdma.interface";
    public static String STORAGE_RDMA_INTERFACE = "eth5";
    public static final String STORAGE_RDMA_PORT_KEY = "crail.storage.rdma.port";
    public static int STORAGE_RDMA_PORT = 50020;
    public static final String STORAGE_RDMA_STORAGE_LIMIT_KEY = "crail.storage.rdma.storagelimit";
    public static long STORAGE_RDMA_STORAGE_LIMIT = 0x40000000L;
    public static final String STORAGE_RDMA_ALLOCATION_SIZE_KEY = "crail.storage.rdma.allocationsize";
    public static long STORAGE_RDMA_ALLOCATION_SIZE = CrailConstants.REGION_SIZE;
    public static final String STORAGE_RDMA_DATA_PATH_KEY = "crail.storage.rdma.datapath";
    public static String STORAGE_RDMA_DATA_PATH = "/dev/hugepages/data";
    public static final String STORAGE_RDMA_LOCAL_MAP_KEY = "crail.storage.rdma.localmap";
    public static boolean STORAGE_RDMA_LOCAL_MAP = true;
    public static final String STORAGE_RDMA_QUEUESIZE_KEY = "crail.storage.rdma.queuesize";
    public static int STORAGE_RDMA_QUEUESIZE = 32;
    public static final String STORAGE_RDMA_TYPE_KEY = "crail.storage.rdma.type";
    public static String STORAGE_RDMA_TYPE = "passive";
    public static final String STORAGE_RDMA_PERSISTENT_KEY = "crail.storage.rdma.persistent";
    public static boolean STORAGE_RDMA_PERSISTENT = false;
    public static final String STORAGE_RDMA_BACKLOG_KEY = "crail.storage.rdma.backlog";
    public static int STORAGE_RDMA_BACKLOG = 100;
    public static final String STORAGE_RDMA_CONNECTTIMEOUT_KEY = "crail.storage.rdma.connecttimeout";
    public static int STORAGE_RDMA_CONNECTTIMEOUT = 1000;

    public static void updateConstants(CrailConfiguration conf) {
        if (conf.get(STORAGE_RDMA_INTERFACE_KEY) != null) {
            STORAGE_RDMA_INTERFACE = conf.get(STORAGE_RDMA_INTERFACE_KEY);
        }
        if (conf.get(STORAGE_RDMA_PORT_KEY) != null) {
            STORAGE_RDMA_PORT = Integer.parseInt(conf.get(STORAGE_RDMA_PORT_KEY));
        }
        if (conf.get(STORAGE_RDMA_STORAGE_LIMIT_KEY) != null) {
            STORAGE_RDMA_STORAGE_LIMIT = Long.parseLong(conf.get(STORAGE_RDMA_STORAGE_LIMIT_KEY));
        }
        if (conf.get(STORAGE_RDMA_ALLOCATION_SIZE_KEY) != null) {
            STORAGE_RDMA_ALLOCATION_SIZE = Long.parseLong(conf.get(STORAGE_RDMA_ALLOCATION_SIZE_KEY));
        }
        if (conf.get(STORAGE_RDMA_DATA_PATH_KEY) != null) {
            STORAGE_RDMA_DATA_PATH = conf.get(STORAGE_RDMA_DATA_PATH_KEY);
        }
        if (conf.get(STORAGE_RDMA_LOCAL_MAP_KEY) != null) {
            STORAGE_RDMA_LOCAL_MAP = conf.getBoolean(STORAGE_RDMA_LOCAL_MAP_KEY, false);
        }
        if (conf.get(STORAGE_RDMA_QUEUESIZE_KEY) != null) {
            STORAGE_RDMA_QUEUESIZE = Integer.parseInt(conf.get(STORAGE_RDMA_QUEUESIZE_KEY));
        }
        if (conf.get(STORAGE_RDMA_TYPE_KEY) != null) {
            STORAGE_RDMA_TYPE = conf.get(STORAGE_RDMA_TYPE_KEY);
        }
        if (conf.get(STORAGE_RDMA_PERSISTENT_KEY) != null) {
            STORAGE_RDMA_PERSISTENT = conf.getBoolean(STORAGE_RDMA_PERSISTENT_KEY, false);
        }
        if (conf.get(STORAGE_RDMA_BACKLOG_KEY) != null) {
            STORAGE_RDMA_BACKLOG = Integer.parseInt(conf.get(STORAGE_RDMA_BACKLOG_KEY));
        }
        if (conf.get(STORAGE_RDMA_CONNECTTIMEOUT_KEY) != null) {
            STORAGE_RDMA_CONNECTTIMEOUT = Integer.parseInt(conf.get(STORAGE_RDMA_CONNECTTIMEOUT_KEY));
        }
    }

    public static void verify() throws IOException {
        if (STORAGE_RDMA_ALLOCATION_SIZE % CrailConstants.BLOCK_SIZE != 0L) {
            throw new IOException("crail.storage.rdma.allocationsize must be multiple of crail.blocksize");
        }
        if (STORAGE_RDMA_STORAGE_LIMIT % STORAGE_RDMA_ALLOCATION_SIZE != 0L) {
            throw new IOException("crail.storage.rdma.storageLimit must be multiple of crail.storage.rdma.allocationSize");
        }
        if (!STORAGE_RDMA_TYPE.equalsIgnoreCase("passive") && !STORAGE_RDMA_TYPE.equalsIgnoreCase("active")) {
            throw new IOException("crail.storage.rdma.type must be either <active> or <passive>, found " + STORAGE_RDMA_TYPE);
        }
    }

    public static void printConf(Logger logger) {
        logger.info("crail.storage.rdma.interface " + STORAGE_RDMA_INTERFACE);
        logger.info("crail.storage.rdma.port " + STORAGE_RDMA_PORT);
        logger.info("crail.storage.rdma.storagelimit " + STORAGE_RDMA_STORAGE_LIMIT);
        logger.info("crail.storage.rdma.allocationsize " + STORAGE_RDMA_ALLOCATION_SIZE);
        logger.info("crail.storage.rdma.datapath " + STORAGE_RDMA_DATA_PATH);
        logger.info("crail.storage.rdma.localmap " + STORAGE_RDMA_LOCAL_MAP);
        logger.info("crail.storage.rdma.queuesize " + STORAGE_RDMA_QUEUESIZE);
        logger.info("crail.storage.rdma.type " + STORAGE_RDMA_TYPE);
        logger.info("crail.storage.rdma.backlog " + STORAGE_RDMA_BACKLOG);
        logger.info("crail.storage.rdma.connecttimeout " + STORAGE_RDMA_CONNECTTIMEOUT);
    }

    public static void init(CrailConfiguration conf, String[] args) throws IOException {
        if (args != null) {
            Option interfaceOption = Option.builder((String)"i").desc("interface to start server on").hasArg().build();
            Option portOption = Option.builder((String)"p").desc("port to start server on").hasArg().build();
            Option persistencyOption = Option.builder((String)"s").desc("start from persistent state").build();
            Options options = new Options();
            options.addOption(interfaceOption);
            options.addOption(portOption);
            options.addOption(persistencyOption);
            DefaultParser parser = new DefaultParser();
            try {
                CommandLine line = parser.parse(options, Arrays.copyOfRange(args, 0, args.length));
                if (line.hasOption(interfaceOption.getOpt())) {
                    String ifname = line.getOptionValue(interfaceOption.getOpt());
                    LOG.info("using custom interface " + ifname);
                    conf.set(STORAGE_RDMA_INTERFACE_KEY, ifname);
                }
                if (line.hasOption(portOption.getOpt())) {
                    String port = line.getOptionValue(portOption.getOpt());
                    LOG.info("using custom port " + port);
                    conf.set(STORAGE_RDMA_PORT_KEY, port);
                }
                if (line.hasOption(persistencyOption.getOpt())) {
                    conf.set(STORAGE_RDMA_PERSISTENT_KEY, "true");
                }
            }
            catch (ParseException e) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("RDMA storage tier", options);
                System.exit(-1);
            }
        }
        RdmaConstants.updateConstants(conf);
        RdmaConstants.verify();
    }
}

