/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.storage.rdma.client;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.crail.storage.StorageFuture;
import org.apache.crail.storage.StorageResult;

public class RdmaActiveFuture
implements StorageFuture,
StorageResult {
    protected static int RPC_PENDING = 0;
    protected static int RPC_DONE = 1;
    protected static int RPC_ERROR = 2;
    private long wrid;
    private int len;
    private boolean isWrite;
    private AtomicInteger status;

    public RdmaActiveFuture(long wrid, int len, boolean isWrite) {
        this.wrid = wrid;
        this.len = len;
        this.isWrite = isWrite;
        this.status = new AtomicInteger(RPC_PENDING);
    }

    public long getWrid() {
        return this.wrid;
    }

    public synchronized StorageResult get() throws InterruptedException, ExecutionException {
        if (this.status.get() == RPC_PENDING) {
            try {
                this.wait();
            }
            catch (Exception e) {
                this.status.set(RPC_ERROR);
                throw new InterruptedException(e.getMessage());
            }
        }
        if (this.status.get() == RPC_DONE) {
            return this;
        }
        if (this.status.get() == RPC_PENDING) {
            throw new InterruptedException("RPC timeout");
        }
        throw new InterruptedException("RPC error");
    }

    public synchronized StorageResult get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException {
        if (this.status.get() == RPC_PENDING) {
            try {
                this.wait(timeout);
            }
            catch (Exception e) {
                this.status.set(RPC_ERROR);
                throw new InterruptedException(e.getMessage());
            }
        }
        if (this.status.get() == RPC_DONE) {
            return this;
        }
        if (this.status.get() == RPC_PENDING) {
            throw new InterruptedException("RPC timeout");
        }
        throw new InterruptedException("RPC error");
    }

    public boolean isDone() {
        return this.status.get() > 0;
    }

    public synchronized void signal() {
        this.status.set(RPC_DONE);
        this.notify();
    }

    public int getLen() {
        if (this.status.get() == RPC_DONE) {
            return this.len;
        }
        if (this.status.get() == RPC_PENDING) {
            return 0;
        }
        return -1;
    }

    public boolean isWrite() {
        return this.isWrite;
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    public boolean isCancelled() {
        return false;
    }

    public boolean isSynchronous() {
        return false;
    }
}

