/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.storage.rdma.client;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.crail.storage.StorageFuture;
import org.apache.crail.storage.StorageResult;
import org.apache.crail.storage.rdma.client.RdmaStoragePassiveEndpoint;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;

public class RdmaPassiveFuture
implements StorageFuture,
StorageResult {
    private static final Logger LOG = CrailUtils.getLogger();
    protected static int RPC_PENDING = 0;
    protected static int RPC_DONE = 1;
    protected static int RPC_ERROR = 2;
    private RdmaStoragePassiveEndpoint endpoint;
    private long wrid;
    private int len;
    private boolean isWrite;
    private AtomicInteger status;

    public RdmaPassiveFuture(RdmaStoragePassiveEndpoint endpoint, long wrid, int len, boolean isWrite) {
        this.endpoint = endpoint;
        this.wrid = wrid;
        this.len = len;
        this.isWrite = isWrite;
        this.status = new AtomicInteger(RPC_PENDING);
    }

    public RdmaPassiveFuture get() throws InterruptedException, ExecutionException {
        if (this.status.get() == RPC_PENDING) {
            try {
                this.endpoint.pollUntil(this.status, Long.MAX_VALUE);
            }
            catch (Exception e) {
                this.status.set(RPC_ERROR);
                throw new InterruptedException(e.getMessage());
            }
        }
        if (this.status.get() == RPC_DONE) {
            return this;
        }
        if (this.status.get() == RPC_PENDING) {
            throw new InterruptedException("RPC timeout");
        }
        throw new InterruptedException("RPC error");
    }

    public RdmaPassiveFuture get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.status.get() == RPC_PENDING) {
            try {
                this.endpoint.pollUntil(this.status, timeout);
            }
            catch (Exception e) {
                this.status.set(RPC_ERROR);
                throw new InterruptedException(e.getMessage());
            }
        }
        if (this.status.get() == RPC_DONE) {
            return this;
        }
        if (this.status.get() == RPC_PENDING) {
            throw new InterruptedException("RPC timeout");
        }
        throw new InterruptedException("RPC error");
    }

    public boolean isDone() {
        if (this.status.get() == 0) {
            try {
                this.endpoint.pollOnce();
            }
            catch (Exception e) {
                this.status.set(RPC_ERROR);
                LOG.info(e.getMessage());
            }
        }
        return this.status.get() > 0;
    }

    public void signal(int wcstatus) {
        if (this.status.get() == 0) {
            if (wcstatus == 0) {
                this.status.set(RPC_DONE);
            } else {
                this.status.set(RPC_ERROR);
            }
        }
    }

    public int getLen() {
        if (this.status.get() == RPC_DONE) {
            return this.len;
        }
        if (this.status.get() == RPC_PENDING) {
            return 0;
        }
        return -1;
    }

    public long getWrid() {
        return this.wrid;
    }

    public boolean isWrite() {
        return this.isWrite;
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    public boolean isCancelled() {
        return false;
    }

    public boolean isSynchronous() {
        return false;
    }
}

