/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.storage.rdma.client;

import com.ibm.disni.RdmaActiveEndpoint;
import com.ibm.disni.RdmaActiveEndpointGroup;
import com.ibm.disni.verbs.IbvMr;
import com.ibm.disni.verbs.IbvSendWR;
import com.ibm.disni.verbs.IbvSge;
import com.ibm.disni.verbs.IbvWC;
import com.ibm.disni.verbs.RdmaCmId;
import com.ibm.disni.verbs.SVCPostSend;
import com.ibm.disni.verbs.SVCRegMr;
import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import org.apache.crail.CrailBuffer;
import org.apache.crail.conf.CrailConstants;
import org.apache.crail.metadata.BlockInfo;
import org.apache.crail.storage.StorageEndpoint;
import org.apache.crail.storage.StorageFuture;
import org.apache.crail.storage.rdma.MrCache;
import org.apache.crail.storage.rdma.RdmaConstants;
import org.apache.crail.storage.rdma.client.RdmaActiveFuture;
import org.apache.crail.storage.rdma.client.RdmaStorageActiveGroup;
import org.apache.crail.utils.AtomicIntegerModulo;

public class RdmaStorageActiveEndpoint
extends RdmaActiveEndpoint
implements StorageEndpoint {
    private LinkedBlockingQueue<SVCPostSend> writeOps = new LinkedBlockingQueue();
    private LinkedBlockingQueue<SVCPostSend> readOps = new LinkedBlockingQueue();
    private AtomicIntegerModulo opcount = new AtomicIntegerModulo();
    private Semaphore sendQueueAvailable;
    private ConcurrentHashMap<Long, RdmaActiveFuture> futureMap = new ConcurrentHashMap();
    private MrCache mrCache;
    private MrCache.DeviceMrCache deviceCache;

    public RdmaStorageActiveEndpoint(RdmaStorageActiveGroup group, RdmaCmId id, boolean serverSide) throws IOException {
        super((RdmaActiveEndpointGroup)group, id, serverSide);
        this.sendQueueAvailable = new Semaphore(RdmaConstants.STORAGE_RDMA_QUEUESIZE);
        this.mrCache = group.getMrCache();
        this.deviceCache = null;
    }

    protected synchronized void init() throws IOException {
        super.init();
        for (int i = 0; i < RdmaConstants.STORAGE_RDMA_QUEUESIZE; ++i) {
            SVCPostSend write = this.initWriteOp();
            this.writeOps.add(write);
            SVCPostSend read = this.initReadOp();
            this.readOps.add(read);
        }
    }

    private SVCPostSend initWriteOp() throws IOException {
        LinkedList<IbvSendWR> wrList_send = new LinkedList<IbvSendWR>();
        IbvSendWR writeWR = new IbvSendWR();
        writeWR.setWr_id((long)this.opcount.getAndIncrement());
        writeWR.setOpcode(0);
        LinkedList<IbvSge> sgeListWrite = new LinkedList<IbvSge>();
        IbvSge sgeSendWrite = new IbvSge();
        sgeListWrite.add(sgeSendWrite);
        writeWR.setSg_list(sgeListWrite);
        wrList_send.add(writeWR);
        IbvSendWR readWR = new IbvSendWR();
        readWR.setWr_id((long)this.opcount.getAndIncrement());
        readWR.setOpcode(4);
        readWR.setSend_flags(IbvSendWR.IBV_SEND_SIGNALED);
        LinkedList<IbvSge> sgeListRead = new LinkedList<IbvSge>();
        IbvSge sgeSendRead = new IbvSge();
        sgeSendRead.setLength(1);
        sgeListRead.add(sgeSendRead);
        readWR.setSg_list(sgeListRead);
        wrList_send.add(readWR);
        SVCPostSend rdmaOp = this.postSend(wrList_send);
        return rdmaOp;
    }

    private SVCPostSend initReadOp() throws IOException {
        LinkedList<IbvSendWR> wrList_send = new LinkedList<IbvSendWR>();
        LinkedList<IbvSge> sgeList = new LinkedList<IbvSge>();
        IbvSge sgeSend = new IbvSge();
        IbvSendWR sendWR = new IbvSendWR();
        sgeList.add(sgeSend);
        sendWR.setSg_list(sgeList);
        wrList_send.add(sendWR);
        sendWR.setWr_id((long)this.opcount.getAndIncrement());
        sendWR.setOpcode(4);
        sendWR.setSend_flags(IbvSendWR.IBV_SEND_SIGNALED);
        SVCPostSend rdmaOp = this.postSend(wrList_send);
        return rdmaOp;
    }

    public StorageFuture write(CrailBuffer buffer, BlockInfo remoteMr, long remoteOffset) throws IOException, InterruptedException {
        IbvMr localMr;
        if ((long)buffer.remaining() > CrailConstants.BLOCK_SIZE) {
            throw new IOException("write size too large " + buffer.remaining());
        }
        if (buffer.remaining() <= 0) {
            throw new IOException("write size too small, len " + buffer.remaining());
        }
        if (remoteOffset < 0L) {
            throw new IOException("remote offset too small " + remoteOffset);
        }
        if (remoteMr.getAddr() == 0L) {
            throw new IOException("remote addr is 0 " + remoteMr.getAddr());
        }
        if (remoteMr.getLkey() == 0) {
            throw new IOException("remote key is 0 " + remoteMr.getLkey());
        }
        if (this.deviceCache == null) {
            this.deviceCache = this.mrCache.getDeviceCache(this.getPd());
        }
        if ((localMr = this.deviceCache.get(buffer.getRegion())) == null) {
            localMr = ((SVCRegMr)((SVCRegMr)this.registerMemory(buffer.getRegion().getByteBuffer()).execute()).free()).getMr();
            this.deviceCache.put(localMr);
        }
        long bufferAddress = buffer.address();
        SVCPostSend writeOp = this.writeOps.take();
        SVCPostSend.SendWRMod sendWriteWR = writeOp.getWrMod(0);
        sendWriteWR.setWr_id((long)this.opcount.getAndIncrement());
        sendWriteWR.getRdmaMod().setRemote_addr(remoteMr.getAddr() + remoteOffset);
        sendWriteWR.getRdmaMod().setRkey(remoteMr.getLkey());
        SVCPostSend.SgeMod sgeSendWrite = writeOp.getWrMod(0).getSgeMod(0);
        sgeSendWrite.setAddr(bufferAddress + (long)buffer.position());
        sgeSendWrite.setLength(buffer.remaining());
        sgeSendWrite.setLkey(localMr.getLkey());
        SVCPostSend.SendWRMod sendReadWR = writeOp.getWrMod(1);
        sendReadWR.setWr_id((long)this.opcount.getAndIncrement());
        sendReadWR.getRdmaMod().setRemote_addr(remoteMr.getAddr() + remoteOffset);
        sendReadWR.getRdmaMod().setRkey(remoteMr.getLkey());
        SVCPostSend.SgeMod sgeSendRead = writeOp.getWrMod(1).getSgeMod(0);
        sgeSendRead.setAddr(bufferAddress + (long)buffer.position());
        sgeSendRead.setLkey(localMr.getLkey());
        this.sendQueueAvailable.acquire();
        this.sendQueueAvailable.acquire();
        if (writeOp.getWrMod(0).getRdmaMod().getRkey() == 0) {
            throw new IOException("stag is zero, can't be");
        }
        if (writeOp.getWrMod(1).getRdmaMod().getRkey() == 0) {
            throw new IOException("stag is zero, can't be");
        }
        RdmaActiveFuture future = new RdmaActiveFuture(sendReadWR.getWr_id(), sgeSendWrite.getLength(), true);
        this.futureMap.put(future.getWrid(), future);
        writeOp.execute();
        this.writeOps.add(writeOp);
        return future;
    }

    public StorageFuture read(CrailBuffer buffer, BlockInfo remoteMr, long remoteOffset) throws IOException, InterruptedException {
        IbvMr localMr;
        if ((long)buffer.remaining() > CrailConstants.BLOCK_SIZE) {
            throw new IOException("read size too large");
        }
        if (buffer.remaining() <= 0) {
            throw new IOException("read size too small, len " + buffer.remaining());
        }
        if (remoteOffset < 0L) {
            throw new IOException("remote offset too small " + remoteOffset);
        }
        if (remoteMr.getAddr() == 0L) {
            throw new IOException("remote addr is 0 " + remoteMr.getAddr());
        }
        if (remoteMr.getLkey() == 0) {
            throw new IOException("remote key is 0 " + remoteMr.getLkey());
        }
        if (this.deviceCache == null) {
            this.deviceCache = this.mrCache.getDeviceCache(this.getPd());
        }
        if ((localMr = this.deviceCache.get(buffer.getRegion())) == null) {
            localMr = ((SVCRegMr)((SVCRegMr)this.registerMemory(buffer.getRegion().getByteBuffer()).execute()).free()).getMr();
            this.deviceCache.put(localMr);
        }
        long bufferAddress = buffer.address();
        SVCPostSend readOp = this.readOps.take();
        SVCPostSend.SendWRMod sendWR = readOp.getWrMod(0);
        sendWR.setWr_id((long)this.opcount.getAndIncrement());
        SVCPostSend.SgeMod sgeSend = sendWR.getSgeMod(0);
        sgeSend.setAddr(bufferAddress + (long)buffer.position());
        sgeSend.setLength(buffer.remaining());
        sgeSend.setLkey(localMr.getLkey());
        sendWR.getRdmaMod().setRemote_addr(remoteMr.getAddr() + remoteOffset);
        sendWR.getRdmaMod().setRkey(remoteMr.getLkey());
        this.sendQueueAvailable.acquire();
        if (readOp.getWrMod(0).getRdmaMod().getRkey() == 0) {
            throw new IOException("stag is zero, can't be");
        }
        RdmaActiveFuture future = new RdmaActiveFuture(sendWR.getWr_id(), sgeSend.getLength(), false);
        this.futureMap.put(future.getWrid(), future);
        readOp.execute();
        this.readOps.add(readOp);
        return future;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dispatchCqEvent(IbvWC wc) throws IOException {
        if (wc.getStatus() == 0) {
            RdmaActiveFuture future = this.futureMap.remove(wc.getWr_id());
            if (future == null) throw new IOException("cannot find future object for wrid " + wc.getWr_id() + ", status " + wc.getStatus() + ", opcount " + this.opcount + ", wc.qpnum " + wc.getQp_num() + ", this.qp.num " + this.qp.getQp_num() + ", connstate " + this.getConnState() + ", futureMap.size " + this.futureMap.size());
            future.signal();
            if (future.isWrite()) {
                this.sendQueueAvailable.release(2);
                return;
            } else {
                this.sendQueueAvailable.release();
            }
            return;
        } else {
            if (wc.getStatus() == 5) return;
            throw new IOException("error in wc, status " + wc.getStatus());
        }
    }

    public void close() throws IOException, InterruptedException {
        super.close();
    }

    public int getFreeSlots() {
        return this.sendQueueAvailable.availablePermits();
    }

    public String getAddress() throws IOException {
        return super.getDstAddr().toString();
    }

    public RdmaCmId getContext() {
        return super.getIdPriv();
    }

    public boolean isLocal() {
        return false;
    }
}

