/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.com.caucho.hessian.io.socket;

import com.alibaba.com.caucho.hessian.io.AbstractDeserializer;
import com.alibaba.com.caucho.hessian.io.AbstractHessianInput;
import com.alibaba.com.caucho.hessian.io.IOExceptionWrapper;
import java.io.IOException;
import java.net.InetAddress;

public class InetAddressHolderDeserializer
extends AbstractDeserializer {
    @Override
    public Object readObject(AbstractHessianInput in, Object[] fields) throws IOException {
        try {
            return this.readObject(in, (String[])fields);
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOExceptionWrapper("java.net.InetAddress$InetAddressHolder:" + e, e);
        }
    }

    @Override
    public Object readObject(AbstractHessianInput in, String[] fieldNames) throws IOException {
        try {
            String hostName = null;
            int address = 0;
            for (String fieldName : fieldNames) {
                if ("hostName".equals(fieldName)) {
                    hostName = in.readString();
                    continue;
                }
                if ("address".equals(fieldName)) {
                    address = in.readInt();
                    continue;
                }
                in.readObject();
            }
            byte[] addr = new byte[]{(byte)(address >>> 24 & 0xFF), (byte)(address >>> 16 & 0xFF), (byte)(address >>> 8 & 0xFF), (byte)(address & 0xFF)};
            InetAddress obj = InetAddress.getByAddress(hostName, addr);
            in.addRef(obj);
            return obj;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOExceptionWrapper("java.net.InetAddress$InetAddressHolder:" + e, e);
        }
    }
}

