/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.com.caucho.hessian.io.socket;

import com.alibaba.com.caucho.hessian.io.AbstractDeserializer;
import com.alibaba.com.caucho.hessian.io.AbstractHessianInput;
import com.alibaba.com.caucho.hessian.io.IOExceptionWrapper;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class InetSocketAddressDeserializer
extends AbstractDeserializer {
    @Override
    public Class<?> getType() {
        return InetAddress.class;
    }

    @Override
    public Object readObject(AbstractHessianInput in, Object[] fields) throws IOException {
        try {
            return this.readObject(in, (String[])fields);
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOExceptionWrapper("java.net.InetSocketAddress:" + e, e);
        }
    }

    @Override
    public Object readObject(AbstractHessianInput in, String[] fieldNames) throws IOException {
        try {
            String hostName = null;
            InetAddress address = null;
            int port = 0;
            for (String fieldName : fieldNames) {
                if ("hostName".equals(fieldName)) {
                    hostName = in.readString();
                    continue;
                }
                if ("addr".equals(fieldName)) {
                    address = (InetAddress)in.readObject();
                    continue;
                }
                if ("port".equals(fieldName)) {
                    port = in.readInt();
                    continue;
                }
                in.readObject();
            }
            InetSocketAddress obj = address != null ? new InetSocketAddress(address, port) : (hostName != null ? new InetSocketAddress(hostName, port) : new InetSocketAddress(port));
            in.addRef(obj);
            return obj;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOExceptionWrapper("java.net.InetSocketAddress:" + e, e);
        }
    }
}

